<?php
/**
 * Admin Dashboard Template
 */
 
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="tcvs-admin-wrapper">
    <div class="tcvs-header-container">
        <div class="tcvs-title">
            <h1>
                <span class="dashicons dashicons-awards" style="color: var(--tcvs-primary);"></span> 
                <?php esc_html_e( 'Certificate Verification System', 'tohidul-certificate-verification-system' ); ?>
            </h1>
        </div>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=certificate-add' ) ); ?>" class="tcvs-btn-add">
            <span class="dashicons dashicons-plus-alt2"></span> 
            <?php esc_html_e( 'Add New Certificate', 'tohidul-certificate-verification-system' ); ?>
        </a>
    </div>

    <div class="tcvs-stats-grid">
        <div class="tcvs-stat-card">
            <div class="tcvs-stat-info">
                <h3><?php esc_html_e( 'Total Certificates', 'tohidul-certificate-verification-system' ); ?></h3>
                <div class="count"><?php echo esc_html( number_format_i18n( $total ) ); ?></div>
            </div>
            <div class="tcvs-stat-icon">
                <span class="dashicons dashicons-analytics"></span>
            </div>
        </div>
    </div>

    <div class="tcvs-table-card">
        <form id="tcvs-bulk-action-form" method="post" action="">
            <?php wp_nonce_field( 'tcvs_admin_nonce', 'tcvs_admin_nonce_field' ); ?>
            
            <div class="tcvs-table-header-actions">
                <div class="tcvs-bulk-actions">
                    <select name="action" id="bulk-action-selector-top" style="vertical-align: middle;">
                        <option value="-1"><?php esc_html_e( 'Bulk Actions', 'tohidul-certificate-verification-system' ); ?></option>
                        <option value="tcvs_bulk_delete"><?php esc_html_e( 'Delete Selected', 'tohidul-certificate-verification-system' ); ?></option>
                    </select>
                    <input type="submit" id="doaction" class="button action" value="<?php esc_attr_e( 'Apply', 'tohidul-certificate-verification-system' ); ?>">
                </div>
                <div style="margin-left: auto; color: #666; font-size: 13px;">
                    <?php 
                    /* translators: %s: number of certificates */
                    $tcvs_count_text = esc_html__( 'Showing %s certificates', 'tohidul-certificate-verification-system' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                    
                    printf( 
                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        $tcvs_count_text, 
                        count( $certificates ) 
                    ); 
                    ?>
                </div>
            </div>

            <div class="tcvs-table-responsive" style="overflow-x:auto;">
                <table class="tcvs-modern-table">
                    <thead>
                        <tr>
                            <th class="check-column" style="width: 30px;"><input type="checkbox" id="cb-select-all-1"></th>
                            <th style="width: 80px;"><?php esc_html_e( 'Photo', 'tohidul-certificate-verification-system' ); ?></th>
                            <th><?php esc_html_e( 'Student Info', 'tohidul-certificate-verification-system' ); ?></th>
                            <th><?php esc_html_e( 'Course Details', 'tohidul-certificate-verification-system' ); ?></th>
                            <th><?php esc_html_e( 'Batch No', 'tohidul-certificate-verification-system' ); ?></th>
                            <th><?php esc_html_e( 'Issue Date', 'tohidul-certificate-verification-system' ); ?></th>
                            <th style="text-align: right;"><?php esc_html_e( 'Actions', 'tohidul-certificate-verification-system' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ( ! empty( $certificates ) ) : ?>
                            <?php 
                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            foreach ( $certificates as $tcvs_certificate ) : 
                            ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="certificate_ids[]" value="<?php echo esc_attr( $tcvs_certificate->id ); ?>">
                                    </td>
                                    <td>
                                        <div class="tcvs-avatar">
                                            <?php if ( ! empty( $tcvs_certificate->student_image ) ) : ?>
                                                <img src="<?php echo esc_url( $tcvs_certificate->student_image ); ?>" alt="Student">
                                            <?php else : ?>
                                                <div class="tcvs-avatar-placeholder"><span class="dashicons dashicons-format-image"></span></div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <strong style="font-size: 14px; color: #1e1e1e;"><?php echo esc_html( $tcvs_certificate->student_name ); ?></strong><br>
                                        <span style="color: #64748b; font-size: 12px;"><?php esc_html_e( 'Reg:', 'tohidul-certificate-verification-system' ); ?> </span>
                                        <span class="tcvs-reg-no"><?php echo esc_html( $tcvs_certificate->certificate_number ); ?></span>
                                        <div style="font-size: 12px; color: #64748b; margin-top: 3px;">
                                            <?php esc_html_e( 'Father:', 'tohidul-certificate-verification-system' ); ?> <?php echo esc_html( $tcvs_certificate->father_name ); ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span style="font-weight: 500; color: #334155;"><?php echo esc_html( $tcvs_certificate->course_name ); ?></span>
                                    </td>
                                    <td>
                                        <span class="tcvs-badge tcvs-badge-batch"><?php echo esc_html( $tcvs_certificate->batch_number ); ?></span>
                                    </td>
                                    <td>
                                        <div class="tcvs-date">
                                            <span class="dashicons dashicons-calendar-alt" style="font-size: 14px; width: 14px; height: 14px; color: #64748b;"></span>
                                            <?php 
                                            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                                            $tcvs_display_date = isset($tcvs_certificate->issue_date) ? $tcvs_certificate->issue_date : '';
                                            if ( empty( $tcvs_display_date ) || $tcvs_display_date == '0000-00-00' ) {
                                                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                                                $tcvs_display_date = $tcvs_certificate->created_at;
                                            }
                                            echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $tcvs_display_date ) ) ); 
                                            ?>
                                        </div>
                                    </td>
                                    <td style="text-align: right;">
                                        <div class="tcvs-action-btns" style="justify-content: flex-end;">
                                            <a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=certificate-add&action=edit&id=' . $tcvs_certificate->id ), 'tcvs_edit_cert_' . $tcvs_certificate->id ) ); ?>" class="tcvs-btn-icon tcvs-btn-edit" title="Edit">
                                                <span class="dashicons dashicons-edit"></span>
                                            </a>
                                            <a href="#" class="tcvs-btn-icon tcvs-btn-delete tcvs-delete-btn" data-id="<?php echo esc_attr( $tcvs_certificate->id ); ?>" data-nonce="<?php echo esc_attr( wp_create_nonce( 'tcvs_delete_certificate_' . $tcvs_certificate->id ) ); ?>" title="Delete">
                                                <span class="dashicons dashicons-trash"></span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="7" style="text-align:center; padding: 40px;">
                                    <h3 style="margin: 0; color: #666;"><?php esc_html_e( 'No certificates found.', 'tohidul-certificate-verification-system' ); ?></h3>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </form> 
        
        <?php if ( $total_pages > 1 ) : ?>
        <div class="tcvs-pagination">
            <?php
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
            $tcvs_pagination_args = array(
                'base'    => add_query_arg( 'paged', '%#%' ),
                'total'   => $total_pages,
                'current' => $page,
                'prev_text' => '&laquo;',
                'next_text' => '&raquo;',
            );
            echo wp_kses_post( paginate_links( $tcvs_pagination_args ) );
            ?>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="tcvs-footer-actions">
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=certificate-import-export' ) ); ?>" class="tcvs-footer-link">
            <span class="dashicons dashicons-database-import" style="color: var(--tcvs-primary);"></span>
            <?php esc_html_e( 'Import/Export Data', 'tohidul-certificate-verification-system' ); ?>
        </a>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=certificate-settings' ) ); ?>" class="tcvs-footer-link">
            <span class="dashicons dashicons-admin-settings" style="color: #555;"></span>
            <?php esc_html_e( 'Institute Settings', 'tohidul-certificate-verification-system' ); ?>
        </a>
    </div>

    <form id="tcvs-delete-form" method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" style="display:none;">
        <input type="hidden" name="action" value="tcvs_delete_certificate">
        <input type="hidden" name="certificate_id" id="tcvs-delete-id">
        <input type="hidden" name="tcvs_delete_nonce" id="tcvs-delete-nonce">
    </form>
</div>