jQuery(document).ready(function($) {
    'use strict';

    $(document).on('click', '.tcvs-media-select', function(e) {
        e.preventDefault();
        var button = $(this);
        var targetInputId = button.data('target');
        var previewDivId = button.data('preview');
        var targetInput = $('#' + targetInputId);
        var previewDiv = $('#' + previewDivId);

        if (typeof wp === 'undefined' || !wp.media) { return; }
        if (button.data('media-frame')) { button.data('media-frame').open(); return; }

        var frame = wp.media({
            title: 'Select Image',
            button: { text: 'Use this image' },
            library: { type: 'image' },
            multiple: false
        });

        button.data('media-frame', frame);
        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            targetInput.val(attachment.url);
            if (previewDiv.length) {
                previewDiv.html('<div class="tcvs-image-preview-wrapper" style="margin-top:10px;"><img src="' + attachment.url + '" style="max-width:150px; height:auto;"><br><button type="button" class="button button-link-delete tcvs-media-remove" data-target="' + targetInputId + '" data-preview="' + previewDivId + '" style="margin-top:5px; color:#a00;">Remove Image</button></div>').show();
            }
        });
        frame.open();
    });

    $(document).on('click', '.tcvs-media-remove', function(e) {
        e.preventDefault();
        var button = $(this);
        $('#' + button.data('target')).val('');
        $('#' + button.data('preview')).empty();
    });

    $('.tcvs-delete-btn').on('click', function(e) {
        e.preventDefault();
        if(confirm(tcvs_admin.confirm_delete)) {
            $('#tcvs-delete-id').val($(this).data('id'));
            $('#tcvs-delete-nonce').val($(this).data('nonce'));
            $('#tcvs-delete-form').submit();
        }
    });

    $('#cb-select-all-1').on('click', function() {
        $('input[name="certificate_ids[]"]').prop('checked', this.checked);
    });

    $('#doaction').on('click', function(e) {
        var action = $('#bulk-action-selector-top').val();
        if (action === 'tcvs_bulk_delete') {
            if ($('input[name="certificate_ids[]"]:checked').length === 0) {
                alert('Please select at least one certificate to delete.');
                e.preventDefault();
                return;
            }
            if (!confirm(tcvs_admin.confirm_bulk_delete)) { e.preventDefault(); }
        }
    });
});