(function($){
    $(function(){
        var $wrap = $('.to8gal-fullslider');
        if(!$wrap.length) return;

        $wrap.each(function(){
            var $root = $(this);
            var $track = $root.find('.to8gal-fullslider-track');
            var speed = parseInt($root.data('speed')) || 60;
            var pauseOnHover = $root.data('pause') ? true : false;

            var width = 0;
            $track.children().each(function(){ width += $(this).outerWidth(true); });
            if(width===0) return;

            var pos = 0;
            var last = performance.now();
            var paused = false;

            if(pauseOnHover){
                $root.hover(function(){ paused = true; }, function(){ paused = false; });
            }

            function step(now){
                var dt = (now - last)/1000;
                last = now;
                if(!paused){
                    pos -= speed*dt;
                    if(Math.abs(pos)>=width/2) pos += width/2;
                    $track.css('transform','translateX('+pos+'px)');
                }
                requestAnimationFrame(step);
            }
            requestAnimationFrame(step);

            var overlay = $root.data('overlay');
            if(overlay) $root.find('.to8gal-overlay').css('background',overlay);
        });
    });
})(jQuery);
