jQuery(document).ready(function($){
    $('.proslider-container').each(function(){
        let $container = $(this);
        let $slides = $container.find('.proslider-slide');
        let effect = $container.data('effect') || 'fade';
        let speed = parseInt($container.data('speed')) || 4000;
        let autoplay = $container.data('autoplay') == 1;
        let current = 0;
        let animating = false;
        let timer;

        $slides.css({position:'absolute', top:0, left:0, width:'100%', display:'none'});
        $slides.eq(current).show().css({zIndex:2});

        function showSlide(next, direction = 'next'){ // direction: 'next' or 'prev'
            if(animating || next === current) return;
            animating = true;

            let $current = $slides.eq(current);
            let $next = $slides.eq(next);

            switch(effect){
                case 'slide':
                    let startLeft = (direction === 'next') ? '100%' : '-100%';
                    let endCurrent = (direction === 'next') ? '-100%' : '100%';

                    $next.css({display:'block', left:startLeft, zIndex:3});
                    $current.animate({left:endCurrent}, 500);
                    $next.animate({left:'0%'}, 500, function(){
                        $current.hide().css({left:0});
                        animating=false;
                    });
                    break;

                case 'slide-up':
                    let startTop = (direction === 'next') ? '100%' : '-100%';
                    let endCurrentTop = (direction === 'next') ? '-100%' : '100%';

                    $next.css({display:'block', top:startTop, zIndex:3});
                    $current.animate({top:endCurrentTop}, 500);
                    $next.animate({top:'0%'}, 500, function(){
                        $current.hide().css({top:0});
                        animating=false;
                    });
                    break;

                case 'fade':
                    $next.css({display:'block', opacity:0, zIndex:3})
                         .animate({opacity:1}, 500, function(){
                             $current.hide();
                             animating=false;
                         });
                    break;

                case 'zoom':
                    $next.css({display:'block', transform:'scale(1.2)', opacity:0, zIndex:3})
                        .animate({opacity:1}, {
                            step: function(now){ $(this).css('transform','scale('+(1.2 - 0.2*now)+')'); },
                            duration:600,
                            complete:function(){ $current.hide(); animating=false; }
                        });
                    break;

                default:
                    $current.hide();
                    $next.show();
                    animating=false;
            }

            current = next;
        }

        function nextSlide(){ showSlide((current + 1) % $slides.length, 'next'); }
        function prevSlide(){ showSlide((current - 1 + $slides.length) % $slides.length, 'prev'); }

        if(autoplay && $slides.length > 1) timer = setInterval(nextSlide, speed);

        $container.find('.proslider-next').on('click', function(){ if(timer) clearInterval(timer); nextSlide(); });
        $container.find('.proslider-prev').on('click', function(){ if(timer) clearInterval(timer); prevSlide(); });
    });
});
