<?php

// Enqueue admin scripts/styles
function proslider_enqueue_admin_assets($hook) {
    // Optional: load only on this plugin's admin pages if you want
    // if (strpos($hook, 'proslider') === false) return;

    wp_enqueue_style(
        'proslider-admin-css',
        plugins_url('/css/admin.css', __FILE__)
    );
    wp_enqueue_script(
        'proslider-admin-js',
        plugins_url('/js/admin.js', __FILE__),
        ['jquery'],
        null,
        true
    );
}
add_action('admin_enqueue_scripts', 'proslider_enqueue_admin_assets');

// Add Meta Boxes
function sliderlite_add_meta_boxes() {
    add_meta_box('sliderlite_slides_meta', 'Slides', 'sliderlite_slides_meta_callback', 'proslider', 'normal', 'high');
    add_meta_box('sliderlite_settings_meta', 'Slider Settings', 'sliderlite_settings_meta_callback', 'proslider', 'side', 'default');
}
add_action('add_meta_boxes', 'sliderlite_add_meta_boxes');

// Slides Meta Box
function sliderlite_slides_meta_callback($post) {
    wp_nonce_field('sliderlite_save_slides', 'sliderlite_slides_nonce');
    $slides = get_post_meta($post->ID, 'proslider_slides', true);
    if (!is_array($slides)) $slides = [];

    echo '<div id="sliderlite-slides-wrapper">';
    foreach ($slides as $index => $slide) {
        $index_attr = esc_attr($index);
        $attachment_id = isset($slide['id']) ? intval($slide['id']) : '';
        $attachment_id_attr = esc_attr($attachment_id);
        $preview = $attachment_id ? wp_get_attachment_image($attachment_id, 'thumbnail') : '';
        $preview_safe = wp_kses_post($preview);

        echo '<div class="sliderlite-slide-row" data-index="' . esc_attr($index) . '">';
        echo 'Type: <select name="proslider_slides[' . esc_attr($index) . '][type]">'
            . '<option value="image" ' . selected($slide['type'], 'image', false) . '>Image</option>'
            . '<option value="video" ' . selected($slide['type'], 'video', false) . '>Video</option>'
            . '</select> ';
        echo '<span class="sliderlite-preview">' . wp_kses_post($preview) . '</span> ';
        echo '<input type="hidden" name="proslider_slides[' . esc_attr($index) . '][id]" value="' . esc_attr($attachment_id) . '"> ';

        echo '<button class="button sliderlite-select-media">Select</button> ';

        // Pro-only fields (greyed out)
        echo 'Title: <input type="text" disabled style="width:20%;" placeholder="Pro version"> ';
        echo 'Description: <input type="text" disabled style="width:30%;" placeholder="Pro version"> ';
        echo 'CTA Text: <input type="text" disabled style="width:15%;" placeholder="Pro version"> ';
        echo 'CTA URL: <input type="url" disabled style="width:20%;" placeholder="Pro version"> ';

        echo '<button class="button sliderlite-remove-slide">Remove</button>';
        echo '</div>';
    }
    echo '</div>';
    echo '<button class="button" id="sliderlite-add-slide">Add Slide</button>';

    ?>
    
    <?php
}

// Slides Save
function sliderlite_save_slides_meta( $post_id ) {

    // Prevent autosave
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    // Verify permissions
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    // --- Verify nonce (properly unslashed + sanitized) ---
    if ( isset( $_POST['sliderlite_slides_nonce'] ) ) {
        $nonce = sanitize_text_field( wp_unslash( $_POST['sliderlite_slides_nonce'] ) );
        if ( ! wp_verify_nonce( $nonce, 'sliderlite_save_slides' ) ) {
            return;
        }
    } else {
        return;
    }

    // --- Retrieve and sanitize slides safely ---
    $slides_post = filter_input( INPUT_POST, 'proslider_slides', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY );

        if ( ! is_array( $slides_post ) ) {
            $slides_post = [];
        }

        $sanitized_slides = [];
        foreach ( $slides_post as $index => $slide ) {
            $sanitized_slide = [];

            if ( isset( $slide['type'] ) ) {
                $sanitized_slide['type'] = sanitize_text_field( $slide['type'] );
            }

            if ( isset( $slide['id'] ) ) {
                $sanitized_slide['id'] = intval( $slide['id'] );
            }

            $sanitized_slides[ $index ] = $sanitized_slide;
        }


    update_post_meta( $post_id, 'proslider_slides', $slides_post );
}
add_action( 'save_post', 'sliderlite_save_slides_meta' );



// Settings Meta Box
function sliderlite_settings_meta_callback($post) {
    wp_nonce_field('sliderlite_save_settings', 'sliderlite_settings_nonce');

    $settings = get_post_meta($post->ID, 'proslider_settings', true);
    $effect = $settings['effect'] ?? 'fade';
    $speed  = $settings['speed'] ?? 4000;

    echo '<p><label>Transition Effect:</label></p>';
    echo '<select name="proslider_settings[effect]">';
    $effects = ['fade'=>'Fade','slide'=>'Slide','slide-up'=>'Slide Up','zoom'=>'Zoom'];
    foreach($effects as $key=>$label){
        echo '<option value="'.esc_attr($key).'" '.selected($effect,$key,false).'>'.esc_html($label).'</option>';
    }
    echo '</select>';

    echo '<p style="margin-top:10px;"><label>Autoplay Speed (ms):</label></p>';
    echo '<input type="number" min="100" name="proslider_settings[speed]" value="'.esc_attr($speed).'" style="width:100%;">';

    // Pro-only checkboxes (greyed out)
    echo '<p style="margin-top:8px;"><label><input type="checkbox" disabled> Enable Autoplay (Pro)</label></p>';
    echo '<p style="margin-top:8px;"><label><input type="checkbox" disabled> Show Controls (Pro)</label></p>';
    // Buy Pro button
    echo '<p><a href="https://gumroad.com/l/YOUR_PRODUCT_ID" target="_blank" class="button button-primary" style="margin-bottom:10px;">Buy Pro</a></p>';
}

// Settings Save
function sliderlite_save_settings_meta( $post_id ) {

    // Prevent autosave
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    // Check user permissions
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    // --- Nonce check using filter_input() ---
    $nonce = filter_input( INPUT_POST, 'sliderlite_settings_nonce', FILTER_SANITIZE_STRING );
    if ( ! $nonce || ! wp_verify_nonce( $nonce, 'sliderlite_save_settings' ) ) {
        return;
    }

    // --- Retrieve settings safely ---
    $posted = filter_input( INPUT_POST, 'proslider_settings', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY );
    if ( ! is_array( $posted ) ) {
        $posted = [];
    }

    // --- Sanitize individual fields ---
    $effect = isset( $posted['effect'] ) ? sanitize_text_field( $posted['effect'] ) : 'fade';
    $speed  = isset( $posted['speed'] ) ? intval( $posted['speed'] ) : 4000;

    // Pro-only options ignored
    $settings = [
        'effect'   => $effect,
        'speed'    => $speed,
        'autoplay' => 1,
        'controls' => 0,
    ];

    // --- Save sanitized settings ---
    update_post_meta( $post_id, 'proslider_settings', $settings );
}
add_action( 'save_post', 'sliderlite_save_settings_meta' );



