// admin.js - minimal media uploader + color picker trigger
jQuery(document).ready(function($){
  $('#to8gal_cta_upload').on('click', function(e){
    e.preventDefault();
    var frame = wp.media({
      title: 'Select cta Image',
      library: { type: 'image' },
      button: { text: 'Use this image' },
      multiple: false
    });
    frame.on('select', function(){
      var att = frame.state().get('selection').first().toJSON();
      $('#to8gal_cta_image').val(att.url);
      $('#to8gal_cta_preview').attr('src', att.url).show();
    });
    frame.open();
  });

  $('#to8gal_cta_remove').on('click', function(e){
    e.preventDefault();
    $('#to8gal_cta_image').val('');
    $('#to8gal_cta_preview').attr('src','').hide();
  });

  // color picker: use WP color picker if available
  $('#to8gal_pick_color').on('click', function(e){
    e.preventDefault();
    var $input = $('#to8gal_overlay_color');
    if(!$input.data('wpColorPickerInited')) {
      $input.wpColorPicker({
        change: function(event, ui) {
          $input.val(ui.color.toString());
        }
      });
      $input.data('wpColorPickerInited', true);
      $input.trigger('focus');
    } else {
      $input.trigger('focus');
    }
  });


});


