<?php
/**
 * Tiny Talk Uninstall.
 *
 * Fired when the plugin is uninstalled. Cleans up all plugin data.
 *
 * @package TinyTalk
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete plugin options.
delete_option( 'tiny_talk_agents' );
delete_option( 'tiny_talk_rules' );
delete_option( 'tiny_talk_default_agent' );
delete_option( 'tiny_talk_enabled' );

// Delete post meta from all posts.
delete_post_meta_by_key( '_tiny_talk_agent_id' );
