<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>


<div class="ctl_started-section">

	<div class="tab_panel">
		<div class="wrapper_first">
			<div class="ctl_step">
				<div class="ctl_step-content">
					<div class="ctl_steps-title">
						<h2><?php 
						
						echo esc_html__( '1. Getting Started', 'timeline-widget-addon-for-elementor' ); ?></h2>
					</div>
					<div class="ctl_steps-list">
						<ol>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Start by creating a new page and opening it with Elementor for editing.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Find the Story Timeline widget in Elementor and add it to your page.', 'timeline-widget-addon-for-elementor' ); ?></span> 
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Adjust the layout of your timeline to match how you want your story to look.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
						</ol>

					</div>
				</div>
				<div class="ctl_video-section">
					<iframe width="560" height="315" src="<?php echo esc_url( 'https://www.youtube.com/embed/YGpTusgTQJc?si=RF3WNSTxiPGPqVdR&amp;start=49' ); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
				</div>
			</div>

			<div class="ctl_step ctl_col-rev">
				<div class="ctl_video-section">
					<iframe width="560" height="315" src="https://www.youtube.com/embed/YGpTusgTQJc?si=pCl15zXv9eWcBQ2P&amp;start=135" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
				</div>
				<div class="ctl_step-content">
					<div class="ctl_steps-title">
						<h2><?php 
						
						echo esc_html__( '2. Add Timeline Stories', 'timeline-widget-addon-for-elementor' ); ?></h2>
					</div>
					<div class="ctl_steps-list">
						<ol>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'To add new stories, click the "Add Item" button.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Enter the date and sub-label for each story.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Add a title and description for your stories.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Choose a custom image for each story.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
						</ol>
					</div>
				</div>
			</div>

			<div class="ctl_step">
				<div class="ctl_step-content">
					<div class="ctl_steps-title">
						<h2><?php 
						
						echo esc_html__( '3. Configure Timeline Settings', 'timeline-widget-addon-for-elementor' ); ?></h2>
					</div>
					<div class="ctl_steps-list">
						<ol>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Go to the Style tab to pick the line color.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Customize Label and Year Box settings for a unique look.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Adjust typography settings for a consistent and nice font style.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
							<li class="ctl_step-data">
								<span class="ctl_list-text"><?php 
								
								echo esc_html__( 'Save your changes and preview your page to see the updates.', 'timeline-widget-addon-for-elementor' ); ?></span>
							</li>
						</ol>
					</div>
				</div>
				<div class="ctl_video-section">
					<iframe width="560" height="315" src="https://www.youtube.com/embed/YGpTusgTQJc?si=BMERo2fluqUtEfxb&amp;start=189" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
				</div>
			</div>
		</div>
	</div>
</div>
