<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var array $social
 */

use WPMinimize\TimeFix\Helpers\Functions;

$social_list = Functions::get_social_profile_list();

if ( ! empty( $social ) ) {
	?>
    <div class="timefix-social-profiles-wrapper">
        <span class="timefix-label"><?php esc_html_e( 'Social Profiles', 'timefix' ); ?></span>
        <ul class="timefix-social-profiles">
			<?php
			foreach ( $social_list as $item => $title ) {
				$value = $social[ $item ] ?? '';
				if ( ! empty( $value ) ) {
					?>
                    <li class="social-list-<?php echo esc_attr( $item ); ?>">
                        <a href="<?php echo esc_url( $value ); ?>">
                            <span class="fab fa-<?php echo esc_attr( $item ); ?>"></span>
                        </a>
                    </li>
				<?php }
			} ?>
        </ul>
    </div>
	<?php
}