<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var array $social_profiles
 */

use WPMinimize\TimeFix\Helpers\Functions;

$social_list = Functions::get_social_profile_list();
?>
<div class="wpm-section">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'Social Profiles', 'timefix' ); ?></h4>
    </div>
    <div class="wpm-section-fields">
		<?php
		foreach ( $social_list as $social => $title ) {
			$value = $social_profiles[ $social ] ?? '';
			?>
            <div class="wpm-form-group">
                <label class="wpm-field-label" for="timefix-staff-<?php echo esc_attr( $social ); ?>">
					<?php echo esc_html( $title ); ?>
                </label>
                <input type="url" name="social_profiles[<?php echo esc_attr( $social ); ?>]"
                       value="<?php echo esc_url( $value ); ?>"
                       id="timefix-staff-<?php echo esc_attr( $social ); ?>" class="timefix-input"/>
            </div>
		<?php } ?>
    </div>
</div>