<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * @var array | null $holidays
 * @var array | null $special_date_schedule
 * @var array | null $weekly_schedule
 */

use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Helpers\Utility;

$weekdays = Functions::get_week_days();
?>
<div class="wpm-time-group">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'Weekly Hours', 'timefix' ); ?></h4>
    </div>
    <div class="timefix-service-slots">
        <?php foreach ( $weekdays as $day_key => $day ) { ?>
            <div class="timefix-service-slot">
                <div class="timefix-day-label"><?php echo esc_html( $day ); ?></div>
                <div class="timefix-day-actions">
                    <label class="timefix-switch">
                        <input type="checkbox" name="_timefix_staff_schedule[<?php echo esc_attr( $day_key ); ?>][open]"
                               id="service-hours-open-<?php echo esc_attr( $day_key ); ?>"<?php echo ! empty( $weekly_schedule[ $day_key ]['open'] )
                                ? ' checked' : '' ?>/>
                        <span class="timefix-slider"></span>
                    </label>
                    <div class="action-item time-slots">
                        <?php
                        $count = 0;
                        if ( ! empty( $weekly_schedule[ $day_key ]['times'] ) ) {
                            foreach ( $weekly_schedule[ $day_key ]['times'] as $time_id => $time ) {
                                ?>
                                <div class="time-slot">
                                    <div class="time-slot-start"
                                         data-column="<?php esc_attr_e( 'Start', 'timefix' ); ?>">
                                        <input type="text"
                                               name="_timefix_staff_schedule[<?php echo esc_attr( $day_key ); ?>][times][<?php echo esc_attr( $count ); ?>][start]"
                                               value="<?php echo esc_attr( Utility::formatTime( $time['start'], null, 'H:i' ) ) ?>"
                                               class="timefix-timepicker" autocomplete="off">
                                    </div>
                                    <div class="time-slot-end"
                                         data-column="<?php esc_attr_e( 'End', 'timefix' ); ?>">
                                        <input type="text"
                                               name="_timefix_staff_schedule[<?php echo esc_attr( $day_key ); ?>][times][<?php echo esc_attr( $count ); ?>][end]"
                                               value="<?php echo esc_attr( Utility::formatTime( $time['end'], null, 'H:i' ) ) ?>"
                                               class="timefix-timepicker" autocomplete="off">
                                    </div>
                                    <div class="time-slot-action">
                                        <i class="timefix-btn timefix-btn-remove fa-solid fa-minus"></i>
                                    </div>
                                </div>
                                <?php $count ++;
                            }
                        }
                        ?>
                        <div class="time-slot">
                            <div class="time-slot-start" data-column="<?php esc_attr_e( 'Start', 'timefix' ); ?>">
                                <input type="text"
                                       name="_timefix_staff_schedule[<?php echo esc_attr( $day_key ); ?>][times][<?php echo esc_attr( $count ); ?>][start]"
                                       class="timefix-timepicker" autocomplete="off">
                            </div>
                            <div class="time-slot-end" data-column="<?php esc_attr_e( 'End', 'timefix' ); ?>">
                                <input type="text"
                                       name="_timefix_staff_schedule[<?php echo esc_attr( $day_key ); ?>][times][<?php echo esc_attr( $count ); ?>][end]"
                                       class="timefix-timepicker" autocomplete="off">
                            </div>
                            <div class="time-slot-action">
                                <i class="timefix-btn timefix-btn-add fa-solid fa-plus"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<div class="wpm-time-group">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( "Custom Hours", "timefix" ); ?></h4>
        <p><?php esc_html_e( "Define special date hours to override daily routine.", "timefix" ); ?></p>
    </div>
    <div id="timefix-special-bhs-container">
        <div class="timefix-special-bhs timefix-bhs">
            <?php
            $count = 0;
            if ( ! empty( $special_date_schedule ) ) {
                foreach ( $special_date_schedule as $key => $hours ) { ?>
                    <div class="timefix-special-bh timefix-bh">
                        <div class="timefix-special-bh-date">
                            <input type="text" class="shs timefix-datepicker"
                                   value="<?php echo esc_attr( Utility::formatDate( $hours['date'], null, 'Y-m-d' ) ) ?>"
                                   name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][date]"/>
                        </div>
                        <div class="timefix-special-bh-actions timefix-day-actions">
                            <div class="wpm-form-group">
                                <label class="timefix-switch">
                                    <input type="checkbox"
                                           name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][open]"
                                           id="shs-time-slot-open-<?php echo esc_attr( $count ) ?>" <?php echo ! empty( $hours['times'] ) ? 'checked' : '' ?>/>
                                    <span class="timefix-slider"></span>
                                </label>
                                <label class="wpm-field-label" for="shs-time-slot-open-<?php echo esc_attr( $count ) ?>">
                                    <?php esc_html_e( "Set time slot for the date.", "timefix" ); ?>
                                </label>
                            </div>
                            <div class="action-item time-slots">
                                <?php $time_count = 0;
                                if ( ! empty( $hours['times'] ) ) {
                                    foreach ( $hours['times'] as $time_id => $time ) {
                                        ?>
                                        <div class="time-slot">
                                            <div class="time-slot-start"
                                                 data-column="<?php esc_attr_e( 'Start', 'timefix' ); ?>">
                                                <input type="text"
                                                       name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][times][<?php echo esc_attr( $time_count ) ?>][start]"
                                                       value="<?php echo esc_attr( Utility::formatTime( $time['start'], null, 'H:i' ) ) ?>"
                                                       class="shs timefix-timepicker">
                                            </div>
                                            <div class="time-slot-end"
                                                 data-column="<?php esc_attr_e( 'End', 'timefix' ); ?>">
                                                <input type="text"
                                                       name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][times][<?php echo esc_attr( $time_count ) ?>][end]"
                                                       value="<?php echo esc_attr( Utility::formatTime( $time['end'], null, 'H:i' ) ) ?>"
                                                       class="shs timefix-timepicker">
                                            </div>
                                            <div class="time-slot-action">
                                                <i class="timefix-btn timefix-btn-remove fa-solid fa-minus"></i>
                                            </div>
                                        </div>
                                        <?php $time_count ++;
                                    }
                                } ?>
                                <div class="time-slot">
                                    <div class="time-slot-start">
                                        <input type="text"
                                               name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][times][<?php echo esc_attr( $time_count ) ?>][start]"
                                               class="shs timefix-timepicker">
                                    </div>
                                    <div class="time-slot-end">
                                        <input type="text"
                                               name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][times][<?php echo esc_attr( $time_count ) ?>][end]"
                                               class="shs timefix-timepicker">
                                    </div>
                                    <div class="time-slot-action">
                                        <i class="timefix-btn timefix-btn-add fa-solid fa-plus"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item-actions">
                            <i class="timefix-btn timefix-btn-remove fa-solid fa-minus"></i>
                        </div>
                    </div>
                    <?php $count ++;
                }
            }
            ?>
            <div class="timefix-special-bh timefix-bh">
                <div class="timefix-special-bh-date">
                    <input type="text" class="timefix-datepicker" value=""
                           name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][date]"/>
                </div>
                <div class="timefix-special-bh-actions timefix-day-actions">
                    <div class="wpm-form-group">
                        <label class="timefix-switch">
                            <input type="checkbox"
                                   name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][open]"
                                   id="bho-time-slot-open-<?php echo esc_attr( $count ) ?>"/>
                            <span class="timefix-slider"></span>
                        </label>
                        <label class="wpm-field-label" for="bho-time-slot-open-<?php echo esc_attr( $count ) ?>">
                            <?php esc_html_e( "Set time slot for the date.", "timefix" ); ?>
                        </label>
                    </div>
                    <div class="action-item time-slots">
                        <div class="time-slot">
                            <div class="time-slot-start"
                                 data-column="<?php esc_attr_e( 'Start', 'timefix' ); ?>">
                                <input type="text"
                                       name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][times][0][start]"
                                       class="shs timefix-timepicker">
                            </div>
                            <div class="time-slot-end"
                                 data-column="<?php esc_attr_e( 'End', 'timefix' ); ?>">
                                <input type="text"
                                       name="_timefix_staff_special_schedule[<?php echo esc_attr( $count ) ?>][times][0][end]"
                                       class="shs timefix-timepicker">
                            </div>
                            <div class="time-slot-action">
                                <i class="timefix-btn timefix-btn-add fa-solid fa-plus"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item-actions">
                    <i class="timefix-btn timefix-btn-add fa-solid fa-plus"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="wpm-time-group">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'Holidays', 'timefix' ); ?></h4>
    </div>
    <div class="timefix-holidays">
        <?php
        $count = 0;
        if ( ! empty( $holidays ) ) {
            foreach ( $holidays as $date ) {
                ?>
                <div class="date-slot">
                    <div class="date-slot-input">
                        <input type="text" class="timefix-datepicker"
                               value="<?php echo esc_attr( Utility::formatDate( $date, null, 'Y-m-d' ) ) ?>"
                               name="_timefix_staff_holidays[<?php echo esc_attr( $count ) ?>]"/>
                    </div>
                    <div class="date-slot-action">
                        <i class="timefix-btn timefix-btn-remove fa-solid fa-minus"></i>
                    </div>
                </div>
                <?php
                $count ++;
            }
        }
        ?>
        <div class="date-slot">
            <div class="date-slot-input">
                <input type="text" class="timefix-datepicker"
                       name="_timefix_staff_holidays[<?php echo esc_attr( $count ) ?>]"/>
            </div>
            <div class="date-slot-action">
                <i class="timefix-btn timefix-btn-add fa-solid fa-plus"></i>
            </div>
        </div>
    </div>
</div>