<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var string $speciality
 * @var string $experience
 * @var string $phone
 * @var string $email
 * @var array  $services
 */

use \WPMinimize\TimeFix\Common\ServiceHandler;

$all_services = ServiceHandler::get_all_services();
?>
<div class="wpm-form-group">
    <label class="wpm-field-label" for="wpm-staff-profession">
		<?php esc_html_e( "Speciality", "timefix" ); ?>
    </label>
    <input type="text" name="timefix_speciality" value="<?php echo esc_attr( $speciality ); ?>"
           id="wpm-staff-profession" class="timefix-input"/>
</div>
<div class="wpm-form-group">
    <label class="wpm-field-label" for="wpm-staff-experience">
		<?php esc_html_e( "Experience", "timefix" ); ?>
    </label>
    <input type="text" name="timefix_experience" value="<?php echo esc_attr( $experience ); ?>"
           id="wpm-staff-experience" class="timefix-input"/>
</div>
<div class="wpm-form-group">
    <label class="wpm-field-label" for="wpm-staff-email">
		<?php esc_html_e( "Email", "timefix" ) ?>
    </label>
    <input type="email" name="timefix_email" value="<?php echo esc_attr( $email ); ?>" id="wpm-staff-email"
           class="timefix-input"/>
</div>
<div class="wpm-form-group">
    <label class="wpm-field-label" for="wpm-staff-phone">
		<?php esc_html_e( "Phone", "timefix" ) ?>
    </label>
    <input type="text" name="timefix_phone" value="<?php echo esc_attr( $phone ); ?>" id="wpm-staff-phone"
           class="timefix-input"/>
</div>
<div class="wpm-section">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'Services', 'timefix' ); ?></h4>
    </div>
    <div class="wpm-section-fields">
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="timefix-staff-services">
				<?php esc_html_e( "Assign Services", "timefix" ); ?>
            </label>
            <select name="timefix_services[]" id="timefix-staff-services" class="timefix-select2" multiple="multiple">
				<?php
				foreach ( $all_services as $post_id => $post_title ) {
					?>
                    <option <?php echo in_array( $post_id, $services ) ? 'selected' : ''; ?>
                            value="<?php echo esc_attr( $post_id ); ?>"><?php echo esc_html( $post_title ); ?></option>
					<?php
				}
				?>
            </select>
        </div>
        <div>
            <table id="services_table" class="timefix-table">
                <thead>
                <tr>
                    <th><?php esc_html_e( "Service", "timefix" ); ?></th>
                    <th><?php esc_html_e( "Price", "timefix" ); ?></th>
                    <th><?php esc_html_e( "Capacity", "timefix" ); ?></th>
                    <th><?php esc_html_e( "Duration", "timefix" ); ?></th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>