<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * @var int $price_type
 * @var int $price
 */
?>
<div class="wpm-section">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'Pricing', 'timefix' ); ?></h4>
    </div>
    <div class="wpm-section-fields">
        <div class="wpm-form-group">
            <span class="wpm-field-label"><?php esc_html_e( "Price Type", "timefix" ) ?></span>
            <div class="wpm-radio-fields">
                <div class="wpm-radio-type-option">
                    <input type="radio" name="timefix_price_type" value="fixed" id="wpm-timefix-fixed-price"
                           class="timefix-input" <?php checked( $price_type, 'fixed', true ); ?> required/>
                    <label for="wpm-timefix-fixed-price"><?php esc_html_e( "Fixed", "timefix" ) ?></label>
                </div>
                <div class="wpm-radio-type-option">
                    <input type="radio" name="timefix_price_type" value="hourly" id="wpm-timefix-hourly-price"
                           class="timefix-input" <?php checked( $price_type, 'hourly', true ); ?> required/>
                    <label for="wpm-timefix-hourly-price"><?php esc_html_e( "Hourly", "timefix" ) ?></label>
                </div>
            </div>
        </div>
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="wpm-timefix-price">
				<?php esc_html_e( "Price", "timefix" ) ?>
            </label>
            <input type="number" name="timefix_price" id="wpm-timefix-price" class="timefix-input"
                   value="<?php echo esc_attr( $price ); ?>" required/>
        </div>
    </div>
</div>