<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var int $duration
 * @var int $time_interval
 */

use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Helpers\Options;

$duration_options = Options::duration_options();
unset( $duration_options[0] );
$duration_value = Functions::get_duration_value( $duration );
$duration_unit  = Functions::get_duration_unit( $duration );
?>
<div class="wpm-section">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'General', 'timefix' ); ?></h4>
    </div>
    <div class="wpm-section-fields">
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="timefix-staff-duration">
				<?php esc_html_e( "Duration / Time Slot", "timefix" ); ?>
            </label>
            <input type="number" name="timefix_duration" id="timefix-staff-duration" class="timefix-input"
                   value="<?php echo esc_attr( $duration_value ); ?>"/>
            <select name="timefix_duration_unit" class="timefix-select">
                <option value="minute" <?php selected( $duration_unit, 'minute' ); ?>><?php esc_html_e( 'Minutes', 'timefix' ); ?></option>
                <option value="hour" <?php selected( $duration_unit, 'hour' ); ?>><?php esc_html_e( 'Hours', 'timefix' ); ?></option>
            </select>
        </div>
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="timefix-staff-time-interval">
				<?php esc_html_e( "Time Interval", "timefix" ); ?>
            </label>
            <select name="timefix_time_interval" id="timefix-staff-time-interval" class="timefix-select">
                <option value=""><?php esc_html_e( 'Default', 'timefix' ); ?></option>
				<?php foreach ( Options::duration_options() as $time => $title ) { ?>
                    <option value="<?php echo esc_attr( $time ); ?>" <?php selected( $time_interval, $time, true ); ?>><?php echo esc_html( $title ); ?></option>
				<?php } ?>
            </select>
        </div>
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="timefix-service-capacity">
				<?php esc_html_e( "Capacity Per Slot", "timefix" ); ?>
            </label>
            <input type="number" name="timefix_capacity" id="timefix-service-capacity" class="timefix-input" disabled/>
            <div class="timefix-pro-tag"><span>PRO</span></div>
        </div>
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="timefix-service-deposit">
				<?php esc_html_e( "Enable Deposit", "timefix" ); ?>
            </label>
            <label class="timefix-switch">
                <input type="checkbox" name="timefix_enable_deposit" id="timefix-service-deposit" disabled/>
                <span class="timefix-slider"></span>
            </label>
            <div class="timefix-pro-tag"><span>PRO</span></div>
        </div>
    </div>
</div>