<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * @var string $phone
 * @var string $whatsapp
 * @var string $email
 */
?>
<div class="wpm-section">
    <div class="wpm-section-header">
        <h4><?php esc_html_e( 'Contact Info', 'timefix' ); ?></h4>
    </div>
    <div class="wpm-section-fields">
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="wpm-timefix-phone">
				<?php esc_html_e( "Phone", "timefix" ) ?>
            </label>
            <input type="text" name="timefix_phone" id="wpm-timefix-phone" class="timefix-input"
                   value="<?php echo esc_attr( $phone ); ?>"/>
        </div>

        <div class="wpm-form-group">
            <label class="wpm-field-label" for="wpm-timefix-whatsapp">
				<?php esc_html_e( "WhatsApp", "timefix" ) ?>
            </label>
            <input type="text" name="timefix_whatsapp" id="wpm-timefix-whatsapp" class="timefix-input"
                   value="<?php echo esc_attr( $whatsapp ); ?>"/>
        </div>
        <div class="wpm-form-group">
            <label class="wpm-field-label" for="wpm-timefix-email">
				<?php esc_html_e( "Email", "timefix" ) ?>
            </label>
            <input type="email" name="timefix_email" id="wpm-timefix-email" class="timefix-input"
                   value="<?php echo esc_attr( $email ); ?>"/>
        </div>
    </div>
</div>