<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $wp_query;

if ( 1 != $pages ) : ?>
    <nav class="timefix-global-pagination" aria-label="Pagination">
        <ul>
			<?php if ( $paged > 1 && $showItems < $pages ) : ?>
                <li>
                    <a href="<?php echo esc_url( get_pagenum_link( $paged - 1 ) ); ?>" aria-label="Previous Page">
                        <span>&laquo;</span>
                    </a>
                </li>
			<?php endif; ?>

			<?php for ( $i = 1; $i <= $pages; $i ++ ): ?>
				<?php if ( $paged == $i ) : ?>
                    <li class="active">
                        <span><?php echo absint( $i ); ?></span>
                    </li>
				<?php else: ?>
                    <li>
                        <a href="<?php echo esc_url( get_pagenum_link( $i ) ); ?>"><?php echo absint( $i ); ?></a>
                    </li>
				<?php endif; ?>
			<?php endfor; ?>

			<?php if ( $paged < $pages && $showItems < $pages ) : ?>
                <li>
                    <a href="<?php echo esc_url( get_pagenum_link( $paged + 1 ) ) ?>" aria-label="Next Page">
                        <span>&raquo;</span>
                    </a>
                </li>
			<?php endif; ?>
        </ul>
    </nav>
<?php endif;