<?php
/**
 * Appointment Submission Email Template (User)
 *
 * This template can be overridden by copying it to:
 * yourtheme/timefix/emails/appointment-submission-user-email.php
 *
 * Available variables:
 *
 * @var string $email_heading
 * @var string $appointment_date
 * @var string $appointment_time
 * @var string $service_name
 * @var string $customer_name
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'wpm_timefix_email_header', $email_heading );
?>
    <p style="margin: 0 0 15px; font-size: 16px; line-height: 1.5; color: #333;"><?php printf( __( 'Hi %s,', 'timefix' ), esc_html( $customer_name ?? '' ) ); ?></p>

    <p style="margin: 0 0 15px; font-size: 15px; line-height: 1.5; color: #555;"><?php esc_html_e( 'Your appointment has been successfully submitted.', 'timefix' ); ?></p>

    <ul style="list-style: none; padding: 0; margin: 0 0 15px;">
        <li style="margin-bottom: 10px;">
            <strong style="color: #111;"><?php esc_html_e( 'Date:', 'timefix' ); ?></strong>
            <span style="color: #555;"><?php echo esc_html( $appointment_date ?? '' ); ?></span>
        </li>
        <li style="margin-bottom: 10px;">
            <strong style="color: #111;"><?php esc_html_e( 'Time:', 'timefix' ); ?></strong>
            <span style="color: #555;"><?php echo esc_html( $appointment_time ?? '' ); ?></span>
        </li>
        <li style="margin-bottom: 10px;">
            <strong style="color: #111;"><?php esc_html_e( 'Service:', 'timefix' ); ?></strong>
            <span style="color: #555;"><?php echo esc_html( $service_name ?? '' ); ?></span>
        </li>
    </ul>
<?php
do_action( 'wpm_timefix_email_footer' );