<?php
/**
 * Appointment Cancellation Email Template (User)
 *
 * This template can be overridden by copying it to:
 * yourtheme/timefix/emails/appointment-cancellation-user-email.php
 *
 * Available variables:
 *
 * @var string $email_heading
 * @var int    $appointment_id
 * @var string $service_name
 * @var string $staff_name
 * @var string $customer_name
 * @var string $appointment_date
 * @var string $appointment_time
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'wpm_timefix_email_header', $email_heading );
?>
    <p style="margin: 0 0 15px; font-size: 16px; line-height: 1.5; color: #333;">
		<?php printf( esc_html__( 'Hi %s,', 'timefix' ), esc_html( $customer_name ) ); ?>
    </p>

    <p style="margin: 0 0 15px; font-size: 15px; line-height: 1.5; color: #555;">
		<?php esc_html_e( 'We regret to inform you that your appointment has been cancelled. Below are the details of the cancelled appointment:', 'timefix' ); ?>
    </p>

    <table cellpadding="0" cellspacing="0" border="0" width="100%" style="margin-top: 15px; margin-bottom: 15px;">
        <tr>
            <td><strong><?php esc_html_e( 'Appointment ID:', 'timefix' ); ?></strong></td>
            <td><?php echo esc_html( $appointment_id ); ?></td>
        </tr>
        <tr>
            <td><strong><?php esc_html_e( 'Service:', 'timefix' ); ?></strong></td>
            <td><?php echo esc_html( $service_name ); ?></td>
        </tr>
        <tr>
            <td><strong><?php esc_html_e( 'Staff:', 'timefix' ); ?></strong></td>
            <td><?php echo esc_html( $staff_name ); ?></td>
        </tr>
        <tr>
            <td><strong><?php esc_html_e( 'Date:', 'timefix' ); ?></strong></td>
            <td><?php echo esc_html( $appointment_date ); ?></td>
        </tr>
        <tr>
            <td><strong><?php esc_html_e( 'Time:', 'timefix' ); ?></strong></td>
            <td><?php echo esc_html( $appointment_time ); ?></td>
        </tr>
    </table>

    <p style="margin: 0 0 15px; font-size: 15px; line-height: 1.5; color: #555;">
		<?php esc_html_e( 'If this was a mistake or you would like to rebook, please contact us or use our online booking system.', 'timefix' ); ?>
    </p>

    <p style="margin: 0 0 15px; font-size: 15px; line-height: 1.5; color: #555;">
		<?php esc_html_e( 'We apologize for any inconvenience.', 'timefix' ); ?>
    </p>

<?php
do_action( 'wpm_timefix_email_footer' );