<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var int $post_id
 * @var array | null $service_list
 */
?>
<input type="hidden" id="staff-id" name="staff_id"
       value="<?php echo esc_attr( $post_id ); ?>"/>
<div class="timefix-form-group">
    <label for="service-id"
           class="timefix-input-label"><?php esc_html_e( 'Select Service', 'timefix' ); ?></label>
    <select id="service-id" class="timefix-select2" name="service_id" required>
        <option value=""><?php esc_html_e( 'Select Staff', 'timefix' ); ?></option>
		<?php
		if ( ! empty( $service_list ) ) {
			foreach ( $service_list as $service_id ) {
				if ( wpm_timefix()->service_post_type === get_post_type( $service_id ) ) {
					$service = get_post( $service_id );
					if ( is_object( $service ) ) {
						?>
                        <option value="<?php echo esc_attr( $service->ID ); ?>"><?php echo esc_html( $service->post_title ); ?></option>
						<?php
					}
				}
			}
		}
		?>
    </select>
</div>
