<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var int $post_id
 * @var array | null $staff_list
 */
?>
<input type="hidden" id="service-id" name="service_id"
       value="<?php echo esc_attr( $post_id ); ?>"/>
<div class="timefix-form-group">
	<label for="staff-id"
	       class="timefix-input-label"><?php esc_html_e( 'Select Staff', 'timefix' ); ?></label>
	<select id="staff-id" class="timefix-select2" name="staff_id" required>
		<option value=""><?php esc_html_e( 'Select Staff', 'timefix' ); ?></option>
		<?php
		if ( ! empty( $staff_list ) ) {
			foreach ( $staff_list as $staff_id ) {
				if ( wpm_timefix()->staff_post_type === get_post_type( $staff_id ) ) {
					$staff = get_post( $staff_id );
					if ( is_object( $staff ) ) {
						?>
						<option value="<?php echo esc_attr( $staff->ID ); ?>"><?php echo esc_html( $staff->post_title ); ?></option>
						<?php
					}
				}
			}
		}
		?>
	</select>
</div>