<?php

use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Helpers\GatewayManager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<?php
$is_payment_enable = Functions::is_payment_enabled() && ! GatewayManager::is_woocommerce_payment_enabled();

if ( Functions::is_timefix_pro() && $is_payment_enable ) {
	$gateways = GatewayManager::get_enabled_gateways_info();
	if ( ! empty( $gateways ) ) {
		?>
        <div class="timefix-form-group">
            <h3 class="timefix-payment-method-title"><?php esc_html_e( 'Select Payment Method', 'timefix' ); ?></h3>
            <div class="timefix-payment-methods">
				<?php foreach ( $gateways as $id => $info ): ?>
                    <div class="timefix-payment-method">
                        <label>
                            <input type="radio" name="payment_method" value="<?php echo esc_attr( $id ); ?>" required>
                            <strong><?php echo esc_html( $info['title'] ); ?></strong>
                        </label>
                        <p><?php echo esc_html( $info['description'] ); ?></p>
						<?php if ( ! empty( $info['instructions'] ) ): ?>
                            <div class="instructions"><?php echo esc_html( $info['instructions'] ); ?></div>
						<?php endif; ?>
                    </div>
				<?php endforeach; ?>
            </div>
        </div>
		<?php
	}
}
?>

<div class="timefix-appointments-information-overview">
    <h3 id="timefix-appointment-confirm-heading">
		<?php esc_html_e( 'Appointment Preview', 'timefix' ); ?>
    </h3>
    <div class="preview-card-wrapper">
        <div class="preview-card">
            <div class="preview-card-heading">
                <i class="fa-brands fa-servicestack"></i>
                <span><?php esc_html_e( 'Service Details', 'timefix' ); ?></span>
            </div>
            <div class="preview-card-body">
				<?php if ( ! Functions::is_staff_single() && ! Functions::is_service_single() ): ?>
                    <div class="selected-category">
                        <span><?php esc_html_e( 'Category:', 'timefix' ); ?></span>
                        <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                    </div>
				<?php endif; ?>
                <div class="selected-service">
                    <span><?php esc_html_e( 'Service:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
                <div class="selected-staff">
                    <span><?php esc_html_e( 'Staff:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
            </div>
        </div>
        <div class="preview-card">
            <div class="preview-card-heading">
                <i class="fa-solid fa-calendar-days"></i>
                <span><?php esc_html_e( 'Date & Time', 'timefix' ); ?></span>
            </div>
            <div class="preview-card-body">
                <div class="selected-date">
                    <span><?php esc_html_e( 'Date:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
                <div class="selected-time">
                    <span><?php esc_html_e( 'Time:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
            </div>
        </div>
        <div class="preview-card">
            <div class="preview-card-heading">
                <i class="fa-solid fa-user-tie"></i>
                <span><?php esc_html_e( 'Customer Info', 'timefix' ); ?></span>
            </div>
            <div class="preview-card-body">
                <div class="selected-name">
                    <span><?php esc_html_e( 'Name:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
                <div class="selected-email">
                    <span><?php esc_html_e( 'Email:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
                <div class="selected-phone">
                    <span><?php esc_html_e( 'Phone:', 'timefix' ); ?></span>
                    <span><?php esc_html_e( 'Not selected', 'timefix' ); ?></span>
                </div>
            </div>
        </div>
		<?php if ( $is_payment_enable ) {
			$gateway = GatewayManager::get_gateway( 'offline' );
			if ( $gateway && $gateway->is_enabled() ) {
				?>
                <div class="preview-card offline-payment-instructions">
                    <div class="preview-card-body">
                        <p><?php echo esc_html( $gateway->get_description() ); ?></p>
                    </div>
                </div>
			<?php }
		} ?>
    </div>
</div>
