<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var array | null $terms
 */
?>
<div class="timefix-form-group">
    <label for="service-cats" class="timefix-input-label">
		<?php esc_html_e( 'Service Categories', 'timefix' ); ?>
    </label>
    <select id="service-cats" class="timefix-select2" name="service_cats" required>
        <option value=""><?php esc_html_e( 'Select Category', 'timefix' ); ?></option>
		<?php foreach ( $terms as $term ): ?>
            <option value="<?php echo esc_attr( $term['id'] ); ?>">
				<?php echo esc_html( $term['label'] ); ?>
            </option>
		<?php endforeach; ?>
    </select>
</div>