<?php
defined( 'ABSPATH' ) || exit;

require_once WPM_TIMEFIX_PATH . 'vendor/autoload.php';

use WPMinimize\TimeFix\Admin\RegisterMetaFields;
use WPMinimize\TimeFix\Admin\SavePostMeta;
use WPMinimize\TimeFix\Admin\RegisterMenu;
use WPMinimize\TimeFix\Api\ApiInit;
use WPMinimize\TimeFix\Common\EmailHooks;
use WPMinimize\TimeFix\Frontend\AjaxHooks;
use WPMinimize\TimeFix\Frontend\Shortcodes;
use WPMinimize\TimeFix\Helpers\GatewayManager;
use WPMinimize\TimeFix\Helpers\Options;
use WPMinimize\TimeFix\Models\Factory;
use WPMinimize\TimeFix\Common\PostTypes;
use WPMinimize\TimeFix\Frontend\TemplateHooks;
use WPMinimize\TimeFix\Frontend\TemplateLoader;
use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Helpers\Installer;
use WPMinimize\TimeFix\Helpers\Utility;
use WPMinimize\TimeFix\Frontend\FilterHooks as FrontendFilterHooks;
use WPMinimize\TimeFix\Frontend\ActionHooks as FrontendActionHooks;
use WPMinimize\TimeFix\Admin\FilterHooks as AdminFilterHooks;
use WPMinimize\TimeFix\Admin\ActionHooks as AdminActionHooks;
use WPMinimize\TimeFix\Payments\WooCommerce\ProductCompatibility;
use WPMinimize\TimeFix\Widgets\Widget;

if ( ! class_exists( 'WPM_TimeFix' ) ) {

	final class WPM_TimeFix {

		/**
		 * Singleton object.
		 */
		private static $singleton = false;

		/**
		 * @var string
		 */
		protected string $suffix;

		/**
		 * @var string
		 */
		protected string $version;

		/**
		 * @var string
		 */
		public string $service_post_type;

		/**
		 * @var string
		 */
		public string $staff_post_type;

		/**
		 * @var string
		 */
		public string $tax_category;

		/**
		 * Factory instance.
		 *
		 * @var Factory
		 */
		public $factory;

		/**
		 * @var string
		 */
		public string $nonceId;

		/**
		 * @var string
		 */
		public string $nonceText;

		private function __construct() {
			$this->suffix            = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
			$this->version           = ( defined( 'WP_DEBUG' ) && WP_DEBUG ) ? 'wpms' . time() : WPM_TIMEFIX_VERSION;
			$this->service_post_type = 'timefix_services';
			$this->staff_post_type   = 'timefix_staffs';
			$this->tax_category      = 'timefix_categories';
			$this->nonceId           = 'wpm_timefix_wpnonce';
			$this->nonceText         = 'wpm_timefix_nonce_secret';

			$this->load_scripts();
			$this->init();
			$this->define_constants();
		}

		/**
		 * Fetch an instance of the class.
		 */
		final public static function getInstance() {
			if ( self::$singleton === false ) {
				self::$singleton = new self();
			}

			return self::$singleton;
		}

		protected function init() {
			PostTypes::init();
			Widget::init();
			$this->factory = new Factory();
			( new ApiInit() )->run();
			if ( $this->is_request( 'admin' ) ) {
				RegisterMenu::init();
				AdminFilterHooks::init();
				AdminActionHooks::init();
				RegisterMetaFields::init();
				SavePostMeta::init();
			}
			if ( $this->is_request( 'frontend' ) ) {
				$this->frontend_hook();
				FrontendFilterHooks::init();
				FrontendActionHooks::init();
				TemplateHooks::init();
				new Shortcodes();
			}
			if ( $this->is_request( 'ajax' ) ) {
				AjaxHooks::init();
			}
			EmailHooks::init();
			//if ( GatewayManager::is_woocommerce_payment_enabled() ) {
			new ProductCompatibility();
			//}
		}

		private function frontend_hook() {
			add_action( 'init', [ TemplateLoader::class, 'init' ] );
		}

		private function define_constants() {
			if ( ! defined( 'WPM_TIMEFIX_URL' ) ) {
				define( 'WPM_TIMEFIX_URL', plugins_url( '', WPM_TIMEFIX_PLUGIN_FILE ) );
			}
			if ( ! defined( 'WPM_TIMEFIX_SLUG' ) ) {
				define( 'WPM_TIMEFIX_SLUG', basename( dirname( WPM_TIMEFIX_PLUGIN_FILE ) ) );
			}
			if ( ! defined( 'WPM_TIMEFIX_PLUGIN_DIRNAME' ) ) {
				define( 'WPM_TIMEFIX_PLUGIN_DIRNAME', dirname( plugin_basename( WPM_TIMEFIX_PLUGIN_FILE ) ) );
			}
			if ( ! defined( 'WPM_TIMEFIX_PLUGIN_BASENAME' ) ) {
				define( 'WPM_TIMEFIX_PLUGIN_BASENAME', plugin_basename( WPM_TIMEFIX_PLUGIN_FILE ) );
			}
		}

		private function load_scripts() {
			add_action( 'wp_enqueue_scripts', [ $this, 'register_frontend_script' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'register_admin_script' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'load_admin_script_for_staff' ], 12 );
			add_action( 'admin_enqueue_scripts', [ $this, 'load_admin_script_for_service' ], 12 );
			add_action( 'admin_enqueue_scripts', [ $this, 'load_admin_settings_scripts' ], 12 );
			add_action( 'admin_enqueue_scripts', [ $this, 'load_admin_appointments_scripts' ], 12 );
			add_action( 'admin_enqueue_scripts', [ $this, 'load_admin_orders_scripts' ], 12 );
			add_action( 'admin_enqueue_scripts', [ $this, 'load_admin_customers_scripts' ], 12 );
		}

		public function register_common_script() {
			wp_register_style( 'fontawesome', WPM_TIMEFIX_URL . '/assets/vendor/fontawesome/css/all.min.css', '', '6.7.1' );
			wp_register_script( 'wpm-timefix-select2', WPM_TIMEFIX_URL . "/assets/vendor/select2/select2.min.js", '', $this->version, true );
			wp_register_script(
				'daterangepicker', WPM_TIMEFIX_URL . "/assets/vendor/daterangepicker/daterangepicker.js", [
				'jquery',
				'moment'
			], '3.0.5' );
		}

		public function register_frontend_script() {
			$this->register_common_script();
			wp_register_style( 'wpm-timefix-frontend', WPM_TIMEFIX_URL . '/assets/css/frontend.css', '', $this->version );
			wp_register_script( 'wpm-timefix-public', WPM_TIMEFIX_URL . "/assets/js/frontend{$this->suffix}.js", [
				'jquery',
				'wpm-timefix-select2',
				'daterangepicker'
			], $this->version, true );

			wp_enqueue_style( 'fontawesome' );
			wp_enqueue_style( 'wpm-timefix-frontend' );
			wp_enqueue_script( 'wpm-timefix-select2' );

			$service_hours_localize = apply_filters( 'wpm_timefix_service_hours_localize_options', [
				'ajax_url'            => $this->ajax_url(),
				'wpm_timefix_wpnonce' => wp_create_nonce( $this->nonceText ),
			] );

			wp_localize_script( 'wpm-timefix-public', 'wpm_timefix_public', $service_hours_localize );

			wp_enqueue_script( 'wpm-timefix-public' );
		}

		public function register_admin_script() {
			$this->register_common_script();
			wp_register_style( 'wpm-timefix-admin', WPM_TIMEFIX_URL . '/assets/css/admin.css', '', $this->version );
			wp_register_script( 'fullcalendar', WPM_TIMEFIX_URL . "/assets/vendor/fullcalendar/index.global{$this->suffix}.js", '', $this->version, true );
			wp_register_script( 'wpm-timefix-admin', WPM_TIMEFIX_URL . "/assets/js/admin{$this->suffix}.js", [
				'jquery',
				'wpm-timefix-select2',
				'daterangepicker'
			], $this->version, true );
			wp_register_script( 'wpm-timefix-admin-settings', WPM_TIMEFIX_URL . "/assets/js/admin-settings{$this->suffix}.js", [ 'wpm-timefix-admin' ], $this->version, true );
			wp_register_script( 'wpm-timefix-admin-appointments', WPM_TIMEFIX_URL . "/assets/js/admin-appointments{$this->suffix}.js", [ 'wpm-timefix-admin' ], $this->version, true );
			wp_register_script( 'wpm-timefix-admin-orders', WPM_TIMEFIX_URL . "/assets/js/admin-orders{$this->suffix}.js", [ 'wpm-timefix-admin' ], $this->version, true );
			wp_register_script( 'wpm-timefix-admin-customers', WPM_TIMEFIX_URL . "/assets/js/admin-customers{$this->suffix}.js", [ 'wpm-timefix-admin' ], $this->version, true );
			wp_register_script( 'wpm-timefix-appointment-form', WPM_TIMEFIX_URL . "/assets/js/appointment-form{$this->suffix}.js", '', $this->version, true );
			wp_enqueue_script( 'wpm-timefix-appointment-form' );

			$service_hours_localize = apply_filters( 'wpm_timefix_service_hours_localize_options', [
				'timePicker'    => [
					'startDate' => '09:00 AM',
					'locale'    => [
						"format"      => Utility::dateFormatPHPToMoment( Functions::time_format() ),
						"applyLabel"  => esc_html__( "Apply", "timefix" ),
						"cancelLabel" => esc_html__( "Clear", "timefix" )
					]
				],
				'datePicker'    => [
					"format"      => Utility::dateFormatPHPToMoment( Functions::date_format() ),
					"applyLabel"  => esc_html__( "Apply", "timefix" ),
					"cancelLabel" => esc_html__( "Clear", "timefix" )
				],
				'lang'          => [
					'server_error' => esc_html__( "Server Error!!", "timefix" ),
					'confirm'      => esc_html__( "Are you sure to delete?", "timefix" ),

				],
				'timePickerEnd' => [
					'startDate' => '05:00 PM',
				],
				'locale'        => get_bloginfo( 'language' )
			] );

			$admin_common_localize_data = apply_filters( 'wpm_timefix_admin_common_localize_options', [
				'nonce'       => wp_create_nonce( 'wp_rest' ),
				'rest_root'   => esc_url_raw( rest_url() ),
				'date_format' => Utility::dateFormatPHPToMoment( Functions::date_format() ),
				'time_format' => Utility::dateFormatPHPToMoment( Functions::time_format() ),
				'admin_url'   => untrailingslashit( get_admin_url() ),
			] );

			$admin_localize_data = $service_hours_localize + $admin_common_localize_data;

			wp_localize_script( 'wpm-timefix-admin', 'wpm_timefix_admin', $admin_localize_data );
		}

		public function load_admin_settings_scripts() {
			if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'timefix-settings' ) {

				// load styles
				wp_enqueue_style( 'wpm-timefix-admin' );

				// load script
				$localize_data = apply_filters( 'wpm_timefix_admin_settings_localize_options', [
					'duration_options' => Options::duration_options(),
					'currency_list'    => Options::get_currency_list(),
				] );

				wp_localize_script( 'wpm-timefix-admin-settings', 'wpm_timefix_settings', $localize_data );

				wp_enqueue_script( 'wpm-timefix-admin-settings' );
			}
		}

		public function load_admin_appointments_scripts() {
			if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'timefix-appointments' ) {
				// load styles
				wp_enqueue_style( 'wpm-timefix-admin' );
				// load script
				$localize_data = apply_filters( 'wpm_timefix_admin_appointments_localize_options', [
					'appointment_status' => Functions::get_appointment_statuses()
				] );

				wp_localize_script( 'wpm-timefix-admin-appointments', 'wpm_timefix_appointments', $localize_data );

				wp_enqueue_script( 'wpm-timefix-admin-appointments' );
			}
		}

		public function load_admin_orders_scripts() {
			if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'timefix-payments' ) {
				// load styles
				wp_enqueue_style( 'wpm-timefix-admin' );
				// load script
				$localize_data = apply_filters( 'wpm_timefix_admin_orders_localize_options', [
					'order_statuses' => Functions::get_order_statuses()
				] );

				wp_localize_script( 'wpm-timefix-admin-orders', 'wpm_timefix_orders', $localize_data );

				wp_enqueue_script( 'wpm-timefix-admin-orders' );
			}
		}

		public function load_admin_customers_scripts() {
			if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'timefix-customers' ) {
				// load styles
				wp_enqueue_style( 'wpm-timefix-admin' );
				// load script
				wp_enqueue_script( 'wpm-timefix-admin-customers' );
			}
		}

		public function load_admin_script_for_service() {
			global $post_type;

			if ( wpm_timefix()->service_post_type != $post_type ) {
				return;
			}

			// load styles
			wp_enqueue_style( 'wpm-timefix-admin' );
		}

		public function load_admin_script_for_staff() {
			global $post_type;

			if ( wpm_timefix()->staff_post_type != $post_type ) {
				return;
			}

			// load styles
			wp_enqueue_style( 'fontawesome' );
			wp_enqueue_style( 'wpm-timefix-admin' );
			// load script
			wp_enqueue_script( 'daterangepicker' );
			wp_enqueue_script( 'wpm-timefix-select2' );
			wp_enqueue_script( 'wpm-timefix-admin' );
		}

		/**
		 * Get the template path.
		 *
		 * @return string
		 */
		public function get_template_path() {
			return apply_filters( 'wpm_timefix_template_path', 'timefix/' );
		}

		/**
		 * Get the plugin path.
		 *
		 * @return string
		 */
		public function plugin_path() {
			return untrailingslashit( plugin_dir_path( WPM_TIMEFIX_PLUGIN_FILE ) );
		}

		/**
		 * Get Ajax URL.
		 *
		 * @return string
		 */
		public function ajax_url() {
			return admin_url( 'admin-ajax.php', 'relative' );
		}

		/**
		 * @param string $type
		 *
		 * @return bool
		 */
		public function is_request( $type ) {
			switch ( $type ) {
				case 'admin':
					return is_admin();
				case 'ajax':
					return defined( 'DOING_AJAX' );
				case 'cron':
					return defined( 'DOING_CRON' );
				case 'frontend':
					return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' );
				default:
					return '';
			}
		}

		public function wp_query() {
			global $wp_query;

			return $wp_query;
		}

	}

	function wpm_timefix() {
		return WPM_TimeFix::getInstance();
	}

	wpm_timefix();
}

register_activation_hook( WPM_TIMEFIX_PLUGIN_FILE, [ Installer::class, 'activate' ] );
register_deactivation_hook( WPM_TIMEFIX_PLUGIN_FILE, [ Installer::class, 'deactivate' ] );