<?php

namespace WPMinimize\TimeFix\Widgets;

defined( 'ABSPATH' ) || exit;

class Widget {

	public static function init() {
		add_action( 'widgets_init', [ __CLASS__, 'register_widget' ] );
	}

	public static function register_widget() {

		if ( ! is_registered_sidebar( 'timefix-service-single-sidebar' ) ) {
			register_sidebar( [
				'name'          => apply_filters( 'wpm_timefix_service_single_sidebar_title', esc_html__( 'TimeFix - Service Details Sidebar', 'timefix' ) ),
				'id'            => 'timefix-service-single-sidebar',
				'description'   => esc_html__( 'Add widgets on service details page', 'timefix' ),
				'before_widget' => '<div class="widget timefix-widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="timefix-widget-heading"><h3>',
				'after_title'   => '</h3></div>',
			] );
		}

	}

}