<?php

namespace WPMinimize\TimeFix\Traits;

defined( 'ABSPATH' ) || exit;

use WPMinimize\TimeFix\Common\StaffMetaHandler;

trait StaffTrait {
	public static function get_staff_time_slots( $staff_id, $booking_date, $duration, $interval ) {
		global $wpdb;
		$table = $wpdb->prefix . "wpm_timefix_appointment_services";

		// Fetch booked slots for staff on that date
		$booked = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT start_time, end_time 
             FROM {$table} 
             WHERE staff_id = %d 
             AND appointment_date = %s",
				$staff_id,
				date( 'Y-m-d', strtotime( $booking_date ) )
			),
			ARRAY_A
		);

		$booked_slots = [];
		foreach ( $booked as $row ) {
			$booked_slots[] = [
				'start' => strtotime( $booking_date . ' ' . $row['start_time'] ),
				'end'   => strtotime( $booking_date . ' ' . $row['end_time'] ),
			];
		}

		// Check schedule (special > weekly)
		$special_schedule                = StaffMetaHandler::get_meta( $staff_id, 'special_schedule' );
		$date_exists_in_special_schedule = [];

		if ( ! empty( $special_schedule ) && is_array( $special_schedule ) ) {
			foreach ( $special_schedule as $data ) {
				if ( gmdate( 'Y-m-d', strtotime( $data['date'] ) ) === gmdate( 'Y-m-d', strtotime( $booking_date ) ) ) {
					$date_exists_in_special_schedule = $data;
					break;
				}
			}
		}

		if ( empty( $date_exists_in_special_schedule ) ) {
			$weekly_schedule = StaffMetaHandler::get_meta( $staff_id, 'weekly_schedule' );
			$day             = gmdate( 'w', strtotime( $booking_date ) );
			$times           = $weekly_schedule[ $day ]['times'] ?? [];
		} else {
			$times = $date_exists_in_special_schedule['times'] ?? [];
		}

		$time_slots = [];

		if ( ! empty( $times ) ) {
			foreach ( $times as $time ) {
				$generated  = self::generate_time_slots( $time['start'], $time['end'], $duration, $interval, "24", $booking_date, $booked_slots );
				$time_slots = array_merge( $time_slots, $generated );
			}
		}
		error_log( print_r( $time_slots, true ) );

		return $time_slots;
	}

	public static function generate_time_slots( $start_time, $end_time, $duration, $interval, $format = "24", $booking_date = null, $booked_slots = [] ) {
		$slots           = [];
		$start_timestamp = strtotime( $booking_date . ' ' . $start_time );
		$end_timestamp   = strtotime( $booking_date . ' ' . $end_time );

		if ( $duration <= 0 || ! $start_timestamp || ! $end_timestamp ) {
			return [];
		}

		$time_format = ( $format === "12" ) ? "h:i A" : "H:i";

		$step = $duration + max( 0, $interval );

		for ( $time = $start_timestamp; $time + ( $duration * 60 ) <= $end_timestamp; $time += ( $step * 60 ) ) {
			$slot_end_time = $time + ( $duration * 60 );

			// Default status
			$status = "available";

			// Check ANY overlap with booked slots
			foreach ( $booked_slots as $booked ) {
				if ( $time < $booked['end'] && $slot_end_time > $booked['start'] ) {
					$status = "booked";
					break;
				}
			}

			$slots[] = [
				'label'  => wp_date( $time_format, $time ) . " - " . wp_date( $time_format, $slot_end_time ),
				'start'  => wp_date( "H:i", $time ),       // raw start
				'end'    => wp_date( "H:i", $slot_end_time ), // raw end
				'status' => $status
			];
		}

		return $slots;
	}

	/**
	 * @return bool
	 */
	public static function is_staff_archive() {
		return is_post_type_archive( wpm_timefix()->staff_post_type );
	}

	/**
	 * @return bool
	 */
	public static function is_staff_single() {
		return is_singular( wpm_timefix()->staff_post_type );
	}
}
