<?php

namespace WPMinimize\TimeFix\Traits;

defined( 'ABSPATH' ) || exit;

trait SettingsTrait {
	/**
	 * @return mixed|void
	 */
	public static function get_permalink_structure() {

		$saved_permalinks = [];
		if ( $service_single_base = self::get_option_item( 'wpm_timefix_permalink_settings', 'service_single_base' ) ) {
			$saved_permalinks['service_single_base'] = untrailingslashit( $service_single_base );
		}
		if ( $service_archive_base = self::get_option_item( 'wpm_timefix_permalink_settings', 'service_archive_base' ) ) {
			$saved_permalinks['service_archive_base'] = untrailingslashit( $service_archive_base );
		}
		if ( $staff_single_base = self::get_option_item( 'wpm_timefix_permalink_settings', 'staff_single_base' ) ) {
			$saved_permalinks['staff_single_base'] = untrailingslashit( $staff_single_base );
		}
		if ( $staff_archive_base = self::get_option_item( 'wpm_timefix_permalink_settings', 'staff_archive_base' ) ) {
			$saved_permalinks['staff_archive_base'] = untrailingslashit( $staff_archive_base );
		}

		$permalinks = wp_parse_args(
			array_filter( $saved_permalinks ),
			[
				'service_single_base'  => _x( 'timefix_service', 'slug', 'timefix' ),
				'service_archive_base' => _x( 'timefix_services', 'slug', 'timefix' ),
				'staff_single_base'    => _x( 'timefix_staff', 'slug', 'timefix' ),
				'staff_archive_base'   => _x( 'timefix_staffs', 'slug', 'timefix' ),
			]
		);

		return apply_filters( 'wpm_timefix_permalink_structure', $permalinks );
	}

	/**
	 * @param string $id      Setting option id
	 * @param string $item    settings option item id
	 * @param null   $default EXCEPT multi_checkbox you can provide default value if given option does not set any value
	 * @param null   $type    checkbox, multi_checkbox, number
	 *
	 * @return bool|int|mixed|null
	 */
	public static function get_option_item( $id, $item, $default = null, $type = null ) {
		if ( ! $item ) {
			return false;
		}
		$settings = self::get_option( $id );

		if ( $type === 'checkbox' ) {
			if ( isset( $settings[ $item ] ) ) {
				return $settings[ $item ] === 'yes';
			}

			return $default;
		} elseif ( $type === 'multi_checkbox' ) {
			return isset( $settings[ $item ] ) && is_array( $settings[ $item ] ) && in_array( $default, $settings[ $item ] );
		} elseif ( $type === 'number' ) {
			return isset( $settings[ $item ] ) ? absint( $settings[ $item ] ) : absint( $default );
		}

		return isset( $settings[ $item ] ) && ! empty( $settings[ $item ] ) ? $settings[ $item ] : $default;
	}

	/**
	 * @param $id
	 *
	 * @return array
	 */
	public static function get_option( $id ) {
		if ( ! $id ) {
			return [];
		}
		$settings = get_option( $id, [] );

		return apply_filters( $id, $settings );
	}

	/**
	 * @return bool
	 */
	public static function is_payment_enabled() {
		$payment_settings = self::get_option( 'wpm_timefix_payment_settings' );

		return ! empty( $payment_settings['payment_enable'] );
	}
}