<?php

namespace WPMinimize\TimeFix\Traits;

defined( 'ABSPATH' ) || exit;

trait ServiceTrait {
	/**
	 * @return bool
	 */
	public static function is_service_single() {
		return is_singular( wpm_timefix()->service_post_type );
	}

	public static function get_taxonomy_terms_hierarchy( $taxonomy, $hide_empty = false, $parent = 0, $depth = 0 ) {
		$terms = get_terms( [
			'taxonomy'   => $taxonomy,
			'hide_empty' => $hide_empty,
			'parent'     => $parent,
		] );

		$output = [];

		if ( ! empty( $terms ) ) {
			foreach ( $terms as $term ) {
				$output[] = [
					'id'    => $term->term_id,
					'label' => str_repeat( '— ', $depth ) . $term->name,
				];

				// Recursively get children
				$children = self::get_taxonomy_terms_hierarchy( $taxonomy, $hide_empty, $term->term_id, $depth + 1 );
				$output   = array_merge( $output, $children );
			}
		}

		return $output;
	}

	/**
	 * @param $minutes
	 *
	 * @return array
	 */
	public static function split_duration( $minutes ) {
		$minutes = intval( $minutes );

		if ( $minutes >= 60 && $minutes % 60 === 0 ) {
			return [
				'value' => $minutes / 60,
				'unit'  => 'hour',
			];
		}

		return [
			'value' => $minutes,
			'unit'  => 'minute',
		];
	}

	/**
	 * @param $minutes
	 *
	 * @return mixed
	 */
	public static function get_duration_value( $minutes ) {
		return self::split_duration( $minutes )['value'];
	}

	/**
	 * @param $minutes
	 *
	 * @return mixed
	 */
	public static function get_duration_unit( $minutes ) {
		return self::split_duration( $minutes )['unit'];
	}
}
