<?php

namespace WPMinimize\TimeFix\Traits;

defined( 'ABSPATH' ) || exit;

trait OrderTrait {
	public static function get_order_statuses() {
		return apply_filters( 'wpm_timefix_get_order_statuses', [
			'pending'        => esc_html__( 'Pending', 'timefix' ),
			'cancelled'      => esc_html__( 'Cancelled', 'timefix' ),
			'completed'      => esc_html__( 'Completed', 'timefix' ),
			'on_hold'        => esc_html__( 'On Hold', 'timefix' ),
			'failed'         => esc_html__( 'Failed', 'timefix' ),
			'paid'           => esc_html__( 'Paid', 'timefix' ),
			'partially_paid' => esc_html__( 'Partially Paid', 'timefix' ),
			'unpaid'         => esc_html__( 'Unpaid', 'timefix' )
		] );
	}

	public static function get_order_status_title( $status = 'pending' ) {
		$statuses = self::get_order_statuses();

		return $statuses[ $status ];
	}
}