<?php

namespace WPMinimize\TimeFix\Traits;

defined( 'ABSPATH' ) || exit;

trait CustomerTrait {
	public static function get_or_create_customer( $user_id, $name, $email = '', $phone = '' ) {
		global $wpdb;
		$table = $wpdb->prefix . "wpm_timefix_customers";

		if ( $user_id ) {
			$customer = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$table} WHERE wp_user_id = %d", $user_id ) );
			if ( $customer ) {
				return $customer->id;
			}

			$wpdb->insert(
				$table,
				[
					'wp_user_id' => $user_id,
					'name'       => $name,
					'email'      => $email,
					'phone'      => $phone,
				],
				[ '%d', '%s', '%s', '%s' ]
			);

			return $wpdb->insert_id;
		}

		$customer = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$table} WHERE email = %s", $email ) );

		if ( $customer ) {
			return $customer->id;
		}

		$wpdb->insert(
			$table,
			[
				'wp_user_id' => null,
				'name'       => $name,
				'email'      => $email,
				'phone'      => $phone
			],
			[ '%s', '%s', '%s', '%s' ]
		);

		return $wpdb->insert_id;
	}
}