<?php

namespace WPMinimize\TimeFix\Payments\WooCommerce;

use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Payments\BasePaymentGateway;

class WooCommerceGateway extends BasePaymentGateway {
	protected string $id = 'woocommerce';

	public function is_enabled(): bool {
		$payment_settings   = Functions::get_option( 'wpm_timefix_payment_settings' );
		$enabled_wc_gateway = $payment_settings['wc_payment_enable'] ?? '';

		return ! empty( $enabled_wc_gateway ) && Functions::is_woocommerce_activated();
	}

	public function process_payment( $order_data ): array {
		return [
			'success'  => true,
			'redirect' => wc_get_checkout_url()
		];
	}
}
