<?php

namespace WPMinimize\TimeFix\Payments;

use WPMinimize\TimeFix\Helpers\Functions;

abstract class BasePaymentGateway implements PaymentGatewayInterface {
	protected string $id;

	public function get_id(): string {
		return $this->id;
	}

	public function get_settings(): array {
		$option_name = 'wpm_timefix_' . $this->id . '_payment_settings';

		return Functions::get_option( $option_name );
	}

	public function is_enabled(): bool {
		$payment_settings = Functions::get_option( 'wpm_timefix_payment_settings' );
		$enabled_gateways = $payment_settings['payment_methods'] ?? [];

		return in_array( $this->id, $enabled_gateways, true );
	}

	public function get_title(): string {
		return $this->get_settings()['title'] ?? ucfirst( $this->id );
	}

	public function get_description(): string {
		return $this->get_settings()['description'] ?? '';
	}

	public function get_instructions(): string {
		return $this->get_settings()['instructions'] ?? '';
	}
}
