<?php

namespace WPMinimize\TimeFix\Models;

defined( 'ABSPATH' ) || exit;

use WPMinimize\TimeFix\Common\ServiceMetaHandler;
use WPMinimize\TimeFix\Helpers\Functions;

class Service {

	protected $id;

	public function __construct( $service_id = 0 ) {
		$this->id = $service_id;
	}

	public function get_id() {
		return $this->id;
	}

	public function exists() {
		return $this->get_id() && wpm_timefix()->service_post_type === get_post_type( $this->get_id() );
	}

	public function the_title() {
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo apply_filters( 'wpm_timefix_service_the_title', esc_html( $this->get_the_title() ) );
	}

	public function the_permalink() {
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo apply_filters( 'wpm_timefix_service_the_permalink', esc_url( get_the_permalink( $this->get_id() ) ) );
	}

	public function the_content() {
		echo wp_kses_post( $this->get_the_content() );
	}

	public function get_the_title() {
		return apply_filters( 'wpm_timefix_service_get_the_title', get_the_title( $this->get_id() ) );
	}

	public function get_the_permalink() {
		return apply_filters( 'wpm_timefix_service_get_the_permalink', get_the_permalink( $this->get_id() ) );
	}

	public function get_the_content() {
		return apply_filters( 'wpm_timefix_service_get_the_content', get_the_content() );
	}

	public function get_duration() {
		return ServiceMetaHandler::get_meta( $this->get_id(), 'duration' );
	}

	public function get_interval() {
		return ServiceMetaHandler::get_meta( $this->get_id(), 'time_interval' );
	}

	public function get_price() {
		return apply_filters( 'wpm_timefix_service_price', ServiceMetaHandler::get_meta( $this->get_id(), 'price' ) );
	}

	public function get_formatted_price() {
		$formatted_price = Functions::get_formatted_price( $this->get_price() );

		return apply_filters( 'wpm_timefix_service_get_formatted_price', $formatted_price, $this );
	}

	public function get_price_html() {
		$formatted_price = Functions::get_price_html( $this->get_price() );

		return apply_filters( 'wpm_timefix_service_get_formatted_price', $formatted_price, $this );
	}
}
