<?php

namespace WPMinimize\TimeFix\Models;

defined( 'ABSPATH' ) || exit;

class Factory {

	public function get_service( $service_post_id = false ) {
		$service_post_id = $this->get_service_id( $service_post_id );

		if ( ! $service_post_id ) {
			return false;
		}

		try {
			$service = new Service( $service_post_id );
			if ( $service->exists() ) {
				return $service;
			}

			return false;
		} catch ( \Exception $e ) {
			return false;
		}
	}

	private function get_service_id( $service ) {
		global $post;

		if ( false === $service && isset( $post, $post->ID ) && wpm_timefix()->service_post_type === get_post_type( $post->ID ) ) {
			return absint( $post->ID );
		} elseif ( is_numeric( $service ) ) {
			return $service;
		} elseif ( $service instanceof Service ) {
			return $service->get_id();
		} elseif ( ! empty( $service->ID ) ) {
			return $service->ID;
		} else {
			return false;
		}
	}
}
