<?php

namespace WPMinimize\TimeFix\Helpers;

defined( 'ABSPATH' ) || exit;

class Options {
	public static function duration_options() {
		$options = [
			'0'  => esc_html__( '0 Min', 'timefix' ),
			'5'  => esc_html__( '5 Mins', 'timefix' ),
			'10' => esc_html__( '10 Mins', 'timefix' ),
			'15' => esc_html__( '15 Mins', 'timefix' ),
			'20' => esc_html__( '20 Mins', 'timefix' ),
			'25' => esc_html__( '25 Mins', 'timefix' ),
			'30' => esc_html__( '30 Mins', 'timefix' ),
			'35' => esc_html__( '35 Mins', 'timefix' ),
			'40' => esc_html__( '40 Mins', 'timefix' ),
			'45' => esc_html__( '45 Mins', 'timefix' ),
			'50' => esc_html__( '50 Mins', 'timefix' ),
			'55' => esc_html__( '55 Mins', 'timefix' ),
			'60' => esc_html__( '1 Hour', 'timefix' ),
		];

		$options = apply_filters( 'wpm_timefix_duration_options', $options );

		return is_array( $options ) ? $options : [];
	}

	public static function get_currency_symbols() {
		$symbols = [
			'AED' => '&#x62f;.&#x625;',
			'AFN' => '&#x60b;',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => '&fnof;',
			'AOA' => 'Kz',
			'ARS' => '&#36;',
			'AUD' => '&#36;',
			'AWG' => 'Afl.',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '&#36;',
			'BDT' => '&#2547;&nbsp;',
			'BGN' => '&#1083;&#1074;.',
			'BHD' => '.&#x62f;.&#x628;',
			'BIF' => 'Fr',
			'BMD' => '&#36;',
			'BND' => '&#36;',
			'BOB' => 'Bs.',
			'BRL' => '&#82;&#36;',
			'BSD' => '&#36;',
			'BTC' => '&#3647;',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BYN' => 'Br',
			'BZD' => '&#36;',
			'CAD' => '&#36;',
			'CDF' => 'Fr',
			'CHF' => '&#67;&#72;&#70;',
			'CLP' => '&#36;',
			'CNY' => '&yen;',
			'COP' => '&#36;',
			'CRC' => '&#x20a1;',
			'CUC' => '&#36;',
			'CUP' => '&#36;',
			'CVE' => '&#36;',
			'CZK' => '&#75;&#269;',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD&#36;',
			'DZD' => '&#x62f;.&#x62c;',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '&euro;',
			'FJD' => '&#36;',
			'FKP' => '&pound;',
			'GBP' => '&pound;',
			'GEL' => '&#x10da;',
			'GGP' => '&pound;',
			'GHS' => '&#x20b5;',
			'GIP' => '&pound;',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '&#36;',
			'HKD' => 'HK&#36;',
			'HNL' => 'L',
			'HRK' => 'Kn',
			'HTG' => 'G',
			'HUF' => '&#70;&#116;',
			'IDR' => 'Rp',
			'ILS' => '&#8362;',
			'IMP' => '&pound;',
			'INR' => '&#8377;',
			'IQD' => '&#x639;.&#x62f;',
			'IRR' => '&#xfdfc;',
			'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
			'ISK' => 'kr.',
			'JEP' => '&pound;',
			'JMD' => '&#36;',
			'JOD' => '&#x62f;.&#x627;',
			'JPY' => '&yen;',
			'KES' => 'KSh',
			'KGS' => '&#x441;&#x43e;&#x43c;',
			'KHR' => '&#x17db;',
			'KMF' => 'Fr',
			'KPW' => '&#x20a9;',
			'KRW' => '&#8361;',
			'KWD' => '&#x62f;.&#x643;',
			'KYD' => '&#36;',
			'KZT' => 'KZT',
			'LAK' => '&#8365;',
			'LBP' => '&#x644;.&#x644;',
			'LKR' => '&#xdbb;&#xdd4;',
			'LRD' => '&#36;',
			'LSL' => 'L',
			'LYD' => '&#x644;.&#x62f;',
			'MAD' => '&#x62f;.&#x645;.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => '&#x434;&#x435;&#x43d;',
			'MMK' => 'Ks',
			'MNT' => '&#x20ae;',
			'MOP' => 'MOP&#36;',
			'MRO' => 'UM',
			'MUR' => '&#x20a8;',
			'MVR' => '.&#x783;',
			'MWK' => 'MK',
			'MXN' => '&#36;',
			'MYR' => '&#82;&#77;',
			'MZN' => 'MT',
			'NAD' => 'N&#36;',
			'NGN' => '&#8358;',
			'NIO' => 'C&#36;',
			'NOK' => '&#107;&#114;',
			'NPR' => '&#8360;',
			'NZD' => '&#36;',
			'OMR' => '&#x631;.&#x639;.',
			'PAB' => 'B/.',
			'PEN' => 'S/.',
			'PGK' => 'K',
			'PHP' => '&#8369;',
			'PKR' => '&#8360;',
			'PLN' => '&#122;&#322;',
			'PRB' => '&#x440;.',
			'PYG' => '&#8370;',
			'QAR' => '&#x631;.&#x642;',
			'RMB' => '&yen;',
			'RON' => 'lei',
			'RSD' => '&#x434;&#x438;&#x43d;.',
			'RUB' => '&#8381;',
			'RWF' => 'Fr',
			'SAR' => '&#x631;.&#x633;',
			'SBD' => '&#36;',
			'SCR' => '&#x20a8;',
			'SDG' => '&#x62c;.&#x633;.',
			'SEK' => '&#107;&#114;',
			'SGD' => '&#36;',
			'SHP' => '&pound;',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '&#36;',
			'SSP' => '&pound;',
			'STD' => 'Db',
			'SYP' => '&#x644;.&#x633;',
			'SZL' => 'L',
			'THB' => '&#3647;',
			'TJS' => '&#x405;&#x41c;',
			'TMT' => 'm',
			'TND' => '&#x62f;.&#x62a;',
			'TOP' => 'T&#36;',
			'TRY' => '&#8378;',
			'TTD' => '&#36;',
			'TWD' => '&#78;&#84;&#36;',
			'TZS' => 'Sh',
			'UAH' => '&#8372;',
			'UGX' => 'UGX',
			'USD' => '&#36;',
			'UYU' => '&#36;',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VND' => '&#8363;',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'CFA',
			'XCD' => '&#36;',
			'XOF' => 'CFA',
			'XPF' => 'Fr',
			'YER' => '&#xfdfc;',
			'ZAR' => '&#82;',
			'ZMW' => 'ZK',
		];

		return apply_filters( 'wpm_timefix_get_currency_symbols', $symbols );
	}

	public static function get_currency_list() {
		$currency_list = [
			'AED' => esc_html__( 'United Arab Emirates dirham', 'timefix' ),
			'AFN' => esc_html__( 'Afghan afghani', 'timefix' ),
			'ALL' => esc_html__( 'Albanian lek', 'timefix' ),
			'AMD' => esc_html__( 'Armenian dram', 'timefix' ),
			'ANG' => esc_html__( 'Netherlands Antillean guilder', 'timefix' ),
			'AOA' => esc_html__( 'Angolan kwanza', 'timefix' ),
			'ARS' => esc_html__( 'Argentine peso', 'timefix' ),
			'AUD' => esc_html__( 'Australian dollar', 'timefix' ),
			'AWG' => esc_html__( 'Aruban florin', 'timefix' ),
			'AZN' => esc_html__( 'Azerbaijani manat', 'timefix' ),
			'BAM' => esc_html__( 'Bosnia and Herzegovina convertible mark', 'timefix' ),
			'BBD' => esc_html__( 'Barbadian dollar', 'timefix' ),
			'BDT' => esc_html__( 'Bangladeshi taka', 'timefix' ),
			'BGN' => esc_html__( 'Bulgarian lev', 'timefix' ),
			'BHD' => esc_html__( 'Bahraini dinar', 'timefix' ),
			'BIF' => esc_html__( 'Burundian franc', 'timefix' ),
			'BMD' => esc_html__( 'Bermudian dollar', 'timefix' ),
			'BND' => esc_html__( 'Brunei dollar', 'timefix' ),
			'BOB' => esc_html__( 'Bolivian boliviano', 'timefix' ),
			'BRL' => esc_html__( 'Brazilian real', 'timefix' ),
			'BSD' => esc_html__( 'Bahamian dollar', 'timefix' ),
			'BTC' => esc_html__( 'Bitcoin', 'timefix' ),
			'BTN' => esc_html__( 'Bhutanese ngultrum', 'timefix' ),
			'BWP' => esc_html__( 'Botswana pula', 'timefix' ),
			'BYR' => esc_html__( 'Belarusian ruble (old)', 'timefix' ),
			'BYN' => esc_html__( 'Belarusian ruble', 'timefix' ),
			'BZD' => esc_html__( 'Belize dollar', 'timefix' ),
			'CAD' => esc_html__( 'Canadian dollar', 'timefix' ),
			'CDF' => esc_html__( 'Congolese franc', 'timefix' ),
			'CHF' => esc_html__( 'Swiss franc', 'timefix' ),
			'CLP' => esc_html__( 'Chilean peso', 'timefix' ),
			'CNY' => esc_html__( 'Chinese yuan', 'timefix' ),
			'COP' => esc_html__( 'Colombian peso', 'timefix' ),
			'CRC' => esc_html__( 'Costa Rican col&oacute;n', 'timefix' ),
			'CUC' => esc_html__( 'Cuban convertible peso', 'timefix' ),
			'CUP' => esc_html__( 'Cuban peso', 'timefix' ),
			'CVE' => esc_html__( 'Cape Verdean escudo', 'timefix' ),
			'CZK' => esc_html__( 'Czech koruna', 'timefix' ),
			'DJF' => esc_html__( 'Djiboutian franc', 'timefix' ),
			'DKK' => esc_html__( 'Danish krone', 'timefix' ),
			'DOP' => esc_html__( 'Dominican peso', 'timefix' ),
			'DZD' => esc_html__( 'Algerian dinar', 'timefix' ),
			'EGP' => esc_html__( 'Egyptian pound', 'timefix' ),
			'ERN' => esc_html__( 'Eritrean nakfa', 'timefix' ),
			'ETB' => esc_html__( 'Ethiopian birr', 'timefix' ),
			'EUR' => esc_html__( 'Euro', 'timefix' ),
			'FJD' => esc_html__( 'Fijian dollar', 'timefix' ),
			'FKP' => esc_html__( 'Falkland Islands pound', 'timefix' ),
			'GBP' => esc_html__( 'Pound sterling', 'timefix' ),
			'GEL' => esc_html__( 'Georgian lari', 'timefix' ),
			'GGP' => esc_html__( 'Guernsey pound', 'timefix' ),
			'GHS' => esc_html__( 'Ghana cedi', 'timefix' ),
			'GIP' => esc_html__( 'Gibraltar pound', 'timefix' ),
			'GMD' => esc_html__( 'Gambian dalasi', 'timefix' ),
			'GNF' => esc_html__( 'Guinean franc', 'timefix' ),
			'GTQ' => esc_html__( 'Guatemalan quetzal', 'timefix' ),
			'GYD' => esc_html__( 'Guyanese dollar', 'timefix' ),
			'HKD' => esc_html__( 'Hong Kong dollar', 'timefix' ),
			'HNL' => esc_html__( 'Honduran lempira', 'timefix' ),
			'HRK' => esc_html__( 'Croatian kuna', 'timefix' ),
			'HTG' => esc_html__( 'Haitian gourde', 'timefix' ),
			'HUF' => esc_html__( 'Hungarian forint', 'timefix' ),
			'IDR' => esc_html__( 'Indonesian rupiah', 'timefix' ),
			'ILS' => esc_html__( 'Israeli new shekel', 'timefix' ),
			'IMP' => esc_html__( 'Manx pound', 'timefix' ),
			'INR' => esc_html__( 'Indian rupee', 'timefix' ),
			'IQD' => esc_html__( 'Iraqi dinar', 'timefix' ),
			'IRR' => esc_html__( 'Iranian rial', 'timefix' ),
			'IRT' => esc_html__( 'Iranian toman', 'timefix' ),
			'ISK' => esc_html__( 'Icelandic kr&oacute;na', 'timefix' ),
			'JEP' => esc_html__( 'Jersey pound', 'timefix' ),
			'JMD' => esc_html__( 'Jamaican dollar', 'timefix' ),
			'JOD' => esc_html__( 'Jordanian dinar', 'timefix' ),
			'JPY' => esc_html__( 'Japanese yen', 'timefix' ),
			'KES' => esc_html__( 'Kenyan shilling', 'timefix' ),
			'KGS' => esc_html__( 'Kyrgyzstani som', 'timefix' ),
			'KHR' => esc_html__( 'Cambodian riel', 'timefix' ),
			'KMF' => esc_html__( 'Comorian franc', 'timefix' ),
			'KPW' => esc_html__( 'North Korean won', 'timefix' ),
			'KRW' => esc_html__( 'South Korean won', 'timefix' ),
			'KWD' => esc_html__( 'Kuwaiti dinar', 'timefix' ),
			'KYD' => esc_html__( 'Cayman Islands dollar', 'timefix' ),
			'KZT' => esc_html__( 'Kazakhstani tenge', 'timefix' ),
			'LAK' => esc_html__( 'Lao kip', 'timefix' ),
			'LBP' => esc_html__( 'Lebanese pound', 'timefix' ),
			'LKR' => esc_html__( 'Sri Lankan rupee', 'timefix' ),
			'LRD' => esc_html__( 'Liberian dollar', 'timefix' ),
			'LSL' => esc_html__( 'Lesotho loti', 'timefix' ),
			'LYD' => esc_html__( 'Libyan dinar', 'timefix' ),
			'MAD' => esc_html__( 'Moroccan dirham', 'timefix' ),
			'MDL' => esc_html__( 'Moldovan leu', 'timefix' ),
			'MGA' => esc_html__( 'Malagasy ariary', 'timefix' ),
			'MKD' => esc_html__( 'Macedonian denar', 'timefix' ),
			'MMK' => esc_html__( 'Burmese kyat', 'timefix' ),
			'MNT' => esc_html__( 'Mongolian t&ouml;gr&ouml;g', 'timefix' ),
			'MOP' => esc_html__( 'Macanese pataca', 'timefix' ),
			'MRO' => esc_html__( 'Mauritanian ouguiya', 'timefix' ),
			'MUR' => esc_html__( 'Mauritian rupee', 'timefix' ),
			'MVR' => esc_html__( 'Maldivian rufiyaa', 'timefix' ),
			'MWK' => esc_html__( 'Malawian kwacha', 'timefix' ),
			'MXN' => esc_html__( 'Mexican peso', 'timefix' ),
			'MYR' => esc_html__( 'Malaysian ringgit', 'timefix' ),
			'MZN' => esc_html__( 'Mozambican metical', 'timefix' ),
			'NAD' => esc_html__( 'Namibian dollar', 'timefix' ),
			'NGN' => esc_html__( 'Nigerian naira', 'timefix' ),
			'NIO' => esc_html__( 'Nicaraguan c&oacute;rdoba', 'timefix' ),
			'NOK' => esc_html__( 'Norwegian krone', 'timefix' ),
			'NPR' => esc_html__( 'Nepalese rupee', 'timefix' ),
			'NZD' => esc_html__( 'New Zealand dollar', 'timefix' ),
			'OMR' => esc_html__( 'Omani rial', 'timefix' ),
			'PAB' => esc_html__( 'Panamanian balboa', 'timefix' ),
			'PEN' => esc_html__( 'Peruvian nuevo sol', 'timefix' ),
			'PGK' => esc_html__( 'Papua New Guinean kina', 'timefix' ),
			'PHP' => esc_html__( 'Philippine peso', 'timefix' ),
			'PKR' => esc_html__( 'Pakistani rupee', 'timefix' ),
			'PLN' => esc_html__( 'Polish z&#x142;oty', 'timefix' ),
			'PRB' => esc_html__( 'Transnistrian ruble', 'timefix' ),
			'PYG' => esc_html__( 'Paraguayan guaran&iacute;', 'timefix' ),
			'QAR' => esc_html__( 'Qatari riyal', 'timefix' ),
			'RON' => esc_html__( 'Romanian leu', 'timefix' ),
			'RSD' => esc_html__( 'Serbian dinar', 'timefix' ),
			'RUB' => esc_html__( 'Russian ruble', 'timefix' ),
			'RWF' => esc_html__( 'Rwandan franc', 'timefix' ),
			'SAR' => esc_html__( 'Saudi riyal', 'timefix' ),
			'SBD' => esc_html__( 'Solomon Islands dollar', 'timefix' ),
			'SCR' => esc_html__( 'Seychellois rupee', 'timefix' ),
			'SDG' => esc_html__( 'Sudanese pound', 'timefix' ),
			'SEK' => esc_html__( 'Swedish krona', 'timefix' ),
			'SGD' => esc_html__( 'Singapore dollar', 'timefix' ),
			'SHP' => esc_html__( 'Saint Helena pound', 'timefix' ),
			'SLL' => esc_html__( 'Sierra Leonean leone', 'timefix' ),
			'SOS' => esc_html__( 'Somali shilling', 'timefix' ),
			'SRD' => esc_html__( 'Surinamese dollar', 'timefix' ),
			'SSP' => esc_html__( 'South Sudanese pound', 'timefix' ),
			'STD' => esc_html__( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'timefix' ),
			'SYP' => esc_html__( 'Syrian pound', 'timefix' ),
			'SZL' => esc_html__( 'Swazi lilangeni', 'timefix' ),
			'THB' => esc_html__( 'Thai baht', 'timefix' ),
			'TJS' => esc_html__( 'Tajikistani somoni', 'timefix' ),
			'TMT' => esc_html__( 'Turkmenistan manat', 'timefix' ),
			'TND' => esc_html__( 'Tunisian dinar', 'timefix' ),
			'TOP' => esc_html__( 'Tongan pa&#x2bb;anga', 'timefix' ),
			'TRY' => esc_html__( 'Turkish lira', 'timefix' ),
			'TTD' => esc_html__( 'Trinidad and Tobago dollar', 'timefix' ),
			'TWD' => esc_html__( 'New Taiwan dollar', 'timefix' ),
			'TZS' => esc_html__( 'Tanzanian shilling', 'timefix' ),
			'UAH' => esc_html__( 'Ukrainian hryvnia', 'timefix' ),
			'UGX' => esc_html__( 'Ugandan shilling', 'timefix' ),
			'USD' => esc_html__( 'United States dollar', 'timefix' ),
			'UYU' => esc_html__( 'Uruguayan peso', 'timefix' ),
			'UZS' => esc_html__( 'Uzbekistani som', 'timefix' ),
			'VEF' => esc_html__( 'Venezuelan bol&iacute;var', 'timefix' ),
			'VND' => esc_html__( 'Vietnamese &#x111;&#x1ed3;ng', 'timefix' ),
			'VUV' => esc_html__( 'Vanuatu vatu', 'timefix' ),
			'WST' => esc_html__( 'Samoan t&#x101;l&#x101;', 'timefix' ),
			'XAF' => esc_html__( 'Central African CFA franc', 'timefix' ),
			'XCD' => esc_html__( 'East Caribbean dollar', 'timefix' ),
			'XOF' => esc_html__( 'West African CFA franc', 'timefix' ),
			'XPF' => esc_html__( 'CFP franc', 'timefix' ),
			'YER' => esc_html__( 'Yemeni rial', 'timefix' ),
			'ZAR' => esc_html__( 'South African rand', 'timefix' ),
			'ZMW' => esc_html__( 'Zambian kwacha', 'timefix' ),
		];

		return apply_filters( 'wpm_timefix_currency_list', $currency_list );
	}

	public static function get_datepicker_options() {
		$date_options = [
			'minDate'          => Utility::formatDate( date( 'Y-m-d' ) ),
			'timePicker'       => false,
			'timePicker24Hour' => false,
			'locale'           => Functions::date_range_picker_locale(),
			'opens'            => 'center',
			'singleDatePicker' => true,
		];

		return apply_filters( 'wpm_timefix_datepicker_options', $date_options );
	}

}