<?php

namespace WPMinimize\TimeFix\Helpers;

use WPMinimize\TimeFix\Emails\AppointmentCancellationUserEmail;
use WPMinimize\TimeFix\Emails\AppointmentConfirmationUserEmail;
use WPMinimize\TimeFix\Emails\AppointmentSubmissionAdminEmail;
use WPMinimize\TimeFix\Emails\AppointmentSubmissionUserEmail;

class EmailManager {
	protected $emails = [];

	public function __construct() {
		$this->register_emails();
	}

	protected function register_emails() {
		$this->emails['appointment_submission_admin']  = new AppointmentSubmissionAdminEmail();
		$this->emails['appointment_submission_user']   = new AppointmentSubmissionUserEmail();
		$this->emails['appointment_confirmation_user'] = new AppointmentConfirmationUserEmail();
		$this->emails['appointment_cancellation_user'] = new AppointmentCancellationUserEmail();

		$this->emails = apply_filters( 'wpm_timefix_registered_emails', $this->emails );
	}

	public function get_email( $id ) {
		return isset( $this->emails[ $id ] ) ? $this->emails[ $id ] : null;
	}

	public function send_email( $id, $to = '', $placeholders = [], $args = [] ) {
		$email = $this->get_email( $id );
		if ( $email ) {
			$email->set_placeholders( $placeholders );

			if ( empty( $to ) ) {
				$to = $email->get_default_recipient( $placeholders );
			}

			$email->set_recipient( $to );

			if ( isset( $args['cc'] ) ) {
				$email->set_cc( $args['cc'] );
			}

			if ( ! empty( $args['bcc'] ) ) {
				$email->set_bcc( $args['bcc'] );
			}
			if ( ! empty( $args['reply_to'] ) ) {
				$email->set_reply_to( $args['reply_to'] );
			}
			if ( ! empty( $args['attachments'] ) && is_array( $args['attachments'] ) ) {
				foreach ( $args['attachments'] as $file ) {
					$email->add_attachment( $file );
				}
			}

			$email->send();
		}

	}

}