<?php

namespace WPMinimize\TimeFix\Frontend;

defined( 'ABSPATH' ) || exit;

class TemplateLoader {

	private static $theme_support = false;

	public static function init() {

		self::$theme_support = current_theme_supports( 'timefix' );

		//if ( self::$theme_support ) {
		add_filter( 'template_include', [ __CLASS__, 'template_loader' ] );
		//}
	}

	public static function template_loader( $template ) {
		if ( is_embed() ) {
			return $template;
		}

		$default_file = self::get_template_loader_default_file();

		if ( $default_file ) {
			$search_files = self::get_template_loader_files( $default_file );
			$template     = locate_template( $search_files );

			if ( ! $template ) {
				$fallback = wpm_timefix()->plugin_path() . "/templates/" . $default_file;
				$template = file_exists( $fallback ) ? $fallback : '';
				$template = apply_filters( 'wpm_timefix_template_loader_fallback_file', $template, $default_file );
			}
		}

		return $template;
	}

	private static function get_template_loader_default_file() {
		$default_file = '';

		if ( is_singular( wpm_timefix()->service_post_type ) ) {
			$default_file = 'single-' . wpm_timefix()->service_post_type . '.php';
		} elseif ( is_singular( wpm_timefix()->staff_post_type ) ) {
			$default_file = 'single-' . wpm_timefix()->staff_post_type . '.php';
		} elseif ( is_post_type_archive( wpm_timefix()->service_post_type ) ) {
			$default_file = 'archive-' . wpm_timefix()->service_post_type . '.php';
		} elseif ( is_post_type_archive( wpm_timefix()->staff_post_type ) ) {
			$default_file = 'archive-' . wpm_timefix()->staff_post_type . '.php';
		}

		return apply_filters( 'wpm_timefix_template_loader_default_file', $default_file );
	}

	private static function get_template_loader_files( $default_file ) {

		if ( is_page_template() ) {
			$templates[] = get_page_template_slug();
		}

		if ( is_singular( wpm_timefix()->service_post_type ) ) {
			$object       = get_queried_object();
			$name_decoded = urldecode( $object->post_name );
			if ( $name_decoded !== $object->post_name ) {
				$templates[] = "single-" . wpm_timefix()->service_post_type . "-{$name_decoded}.php";
			}
			$templates[] = "single-" . wpm_timefix()->service_post_type . "-{$object->post_name}.php";
		} elseif ( is_singular( wpm_timefix()->staff_post_type ) ) {
			$object       = get_queried_object();
			$name_decoded = urldecode( $object->post_name );
			if ( $name_decoded !== $object->post_name ) {
				$templates[] = "single-" . wpm_timefix()->staff_post_type . "-{$name_decoded}.php";
			}
			$templates[] = "single-" . wpm_timefix()->staff_post_type . "-{$object->post_name}.php";
		}

		$templates = [
			$default_file,
			wpm_timefix()->get_template_path() . $default_file,
		];

		$templates = apply_filters( 'wpm_timefix_template_loader_files', $templates, $default_file );

		return array_unique( $templates );
	}

}