<?php

namespace WPMinimize\TimeFix\Frontend;

defined( 'ABSPATH' ) || exit;

use WPMinimize\TimeFix\Common\ServiceHandler;
use WPMinimize\TimeFix\Common\ServiceMetaHandler;
use WPMinimize\TimeFix\Common\StaffHandler;
use WPMinimize\TimeFix\Common\StaffMetaHandler;
use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Helpers\GatewayManager;
use WPMinimize\TimeFix\Helpers\Options;
use WPMinimize\TimeFix\Helpers\Utility;

class TemplateHooks {

	public static function init() {
		// Container
		add_action( 'wpm_timefix_before_main_content', [ __CLASS__, 'main_container_start' ] );
		add_action( 'wpm_timefix_after_main_content', [ __CLASS__, 'main_container_end' ] );
		// Service archive hook
		add_action( 'wpm_timefix_before_service_loop', [ __CLASS__, 'service_item_wrapper_start' ] );
		add_action( 'wpm_timefix_after_service_loop', [ __CLASS__, 'service_item_wrapper_end' ] );
		add_action( 'wpm_timefix_service_loop_item', [ __CLASS__, 'service_image' ], 10 );
		add_action( 'wpm_timefix_service_loop_item', [ __CLASS__, 'service_title' ], 20 );
		add_action( 'wpm_timefix_service_loop_item', [ __CLASS__, 'service_excerpt' ], 30 );
		add_action( 'wpm_timefix_service_loop_item', [ __CLASS__, 'service_read_more_button' ], 40 );
		add_action( 'wpm_timefix_after_service_loop', [ __CLASS__, 'pagination' ] );
		// Service details hook
		add_action( 'wpm_timefix_single_service_staffs', [ __CLASS__, 'available_staffs' ] );
		add_action( 'wpm_timefix_single_service_attributes', [ __CLASS__, 'service_price' ], 10 );
		add_action( 'wpm_timefix_single_service_attributes', [ __CLASS__, 'service_attributes' ], 20 );
		add_action( 'wpm_timefix_single_service_appointment', [ __CLASS__, 'service_appointment_form' ] );
		// Staff archive hook
		add_action( 'wpm_timefix_before_staff_loop', [ __CLASS__, 'staff_item_wrapper_start' ] );
		add_action( 'wpm_timefix_after_staff_loop', [ __CLASS__, 'staff_item_wrapper_end' ] );
		add_action( 'wpm_timefix_staff_loop_item', [ __CLASS__, 'staff_image' ], 10 );
		add_action( 'wpm_timefix_staff_loop_item', [ __CLASS__, 'staff_info_wrapper_start' ], 15 );
		add_action( 'wpm_timefix_staff_loop_item', [ __CLASS__, 'staff_title' ], 20 );
		add_action( 'wpm_timefix_staff_loop_item', [ __CLASS__, 'staff_designation' ], 30 );
		add_action( 'wpm_timefix_staff_loop_item', [ __CLASS__, 'staff_social_profiles' ], 40 );
		add_action( 'wpm_timefix_staff_loop_item', [ __CLASS__, 'staff_info_wrapper_end' ], 45 );
		add_action( 'wpm_timefix_after_staff_loop', [ __CLASS__, 'pagination' ] );
		// Staff details hooks
		add_action( 'wpm_timefix_staff_info', [ __CLASS__, 'staff_name' ], 10 );
		add_action( 'wpm_timefix_staff_info', [ __CLASS__, 'staff_designation' ], 20 );
		add_action( 'wpm_timefix_staff_info', [ __CLASS__, 'staff_excerpt' ], 30 );
		add_action( 'wpm_timefix_staff_info', [ __CLASS__, 'staff_meta' ], 40 );
		add_action( 'wpm_timefix_staff_info', [ __CLASS__, 'staff_social_profiles' ], 50 );
		add_action( 'wpm_timefix_single_staff_schedule', [ __CLASS__, 'staff_schedule' ], 50 );
		add_action( 'wpm_timefix_single_staff_appointment', [ __CLASS__, 'service_appointment_form' ] );
	}

	public static function staff_name() {
		?>
        <h2 class="timefix-staff-name"><?php the_title(); ?></h2>
		<?php
	}

	public static function staff_designation( $staff_id = 0 ) {
		if ( ! $staff_id ) {
			$staff_id = get_the_ID();
		}
		$speciality = StaffMetaHandler::get_meta( $staff_id, 'speciality' );

		if ( $speciality ) {
			?>
            <span class="timefix-staff-designation"><?php echo esc_html( $speciality ); ?></span>
			<?php
		}
	}

	public static function staff_excerpt() {
		?>
        <div class="timefix-staff-excerpt"><?php the_excerpt(); ?></div>
		<?php
	}

	public static function staff_meta( $staff_id = 0 ) {
		if ( ! $staff_id ) {
			$staff_id = get_the_ID();
		}

		$data = [
			'experience' => StaffMetaHandler::get_meta( $staff_id, 'experience' ),
			'phone'      => StaffMetaHandler::get_meta( $staff_id, 'phone' ),
			'email'      => StaffMetaHandler::get_meta( $staff_id, 'email' ),
		];

		Functions::get_template( 'staff/meta', $data );
	}

	public static function staff_social_profiles( $staff_id = 0 ) {
		if ( ! $staff_id ) {
			$staff_id = get_the_ID();
		}

		$social = StaffMetaHandler::get_meta( $staff_id, 'social_profiles' );
		$social = ! empty( $social ) && is_array( $social ) ? $social : [];

		Functions::get_template( 'staff/social-profiles', [ 'social' => $social ] );
	}

	public static function staff_schedule( $staff_id = 0 ) {
		if ( ! $staff_id ) {
			$staff_id = get_the_ID();
		}

		$weekly_schedule = StaffMetaHandler::get_meta( $staff_id, 'weekly_schedule' );

		Functions::get_template( 'staff/schedule', [ 'weekly_schedule' => $weekly_schedule ] );
	}

	public static function service_appointment_form() {
		$post_id = get_the_ID();

		$staff_list = $service_list = [];

		if ( Functions::is_service_single() ) {
			$staff_list = StaffHandler::get_staffs_by_service_id( $post_id );
		}
		if ( Functions::is_staff_single() ) {
			$service_list = ServiceHandler::get_services_by_staff_id( $post_id );
		}

		$wc_payment_enabled_class = GatewayManager::is_woocommerce_payment_enabled() ? ' timefix-enabled-wc-payment' : '';

		$date_options = Options::get_datepicker_options();
		?>
        <div class="timefix-section timefix-appointment-section">
            <h3 class="timefix-section-heading"><?php esc_html_e( 'Make an Appointment', 'timefix' ); ?></h3>
            <div class="timefix-section-content">
                <div class="timefix-appointment-form-wrapper">
                    <form method="post" class="<?php echo esc_attr( $wc_payment_enabled_class ); ?>"
                          id="timefix-appointment-form" name="timefix_appointment_form">
                        <div class="timefix-form-step" data-step="1">
                            <input type="hidden" id="user-id" name="user_id"
                                   value="<?php echo esc_attr( get_current_user_id() ); ?>"/>
							<?php
							if ( Functions::is_service_single() ) {
								Functions::get_template( 'appointment-form/service-single',
									[
										'post_id'    => $post_id,
										'staff_list' => $staff_list
									] );
							}
							if ( Functions::is_staff_single() ) {
								Functions::get_template( 'appointment-form/staff-single',
									[
										'post_id'      => $post_id,
										'service_list' => $service_list
									] );
							}
							Functions::get_template( 'appointment-form/date-time', [ 'date_options' => $date_options ] );
							?>
                            <button class="timefix-next-btn timefix-btn"
                                    disabled><?php esc_html_e( 'Next', 'timefix' ); ?></button>
                        </div>
                        <div class="timefix-form-step timefix-step-d-none" data-step="2">
							<?php
							Functions::get_template( 'appointment-form/customer-info' );
							?>
                            <button class="timefix-prev-btn timefix-btn"><?php esc_html_e( 'Back', 'timefix' ); ?></button>
                            <button class="timefix-next-btn timefix-btn"><?php esc_html_e( 'Next', 'timefix' ); ?></button>
                        </div>
                        <div class="timefix-form-step timefix-step-d-none timefix-appointments-final-step"
                             data-step="3">
							<?php
							Functions::get_template( 'appointment-form/additional-note' );
							Functions::get_template( 'appointment-form/overview' );
							?>
                            <button class="timefix-btn timefix-prev-btn">
								<?php esc_html_e( 'Back', 'timefix' ); ?>
                            </button>
                            <button type="submit" id="timefix-submit-booking" class="timefix-btn">
								<?php esc_html_e( 'Confirm', 'timefix' ); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
		<?php
	}

	public static function service_price() {
		$post_id = get_the_ID();
		$service = wpm_timefix()->factory->get_service( $post_id );
		$price   = $service->get_price_html();
		echo $price;
	}

	public static function service_attributes() {
		$post_id  = get_the_ID();
		$phone    = ServiceMetaHandler::get_meta( $post_id, 'phone' );
		$duration = ServiceMetaHandler::get_meta( $post_id, 'duration' );
		$email    = ServiceMetaHandler::get_meta( $post_id, 'email' );
		$whatsapp = ServiceMetaHandler::get_meta( $post_id, 'whatsapp' );
		?>
        <div class="timefix-widget timefix-service-attributes-wrapper">
            <h3 class="timefix-widget-heading"><?php esc_html_e( 'Details', 'timefix' ); ?></h3>
            <ul class="timefix-service-attributes timefix-widget-content">
                <li>
                    <span class="timefix-service-attribute-title"><?php esc_html_e( 'Duration', 'timefix' ); ?>:</span>
                    <span class="timefix-service-attribute-value">
                        <?php echo esc_html( sprintf( _nx( '%s Min', '%s Mins', $duration, 'Service duration', 'timefix' ), number_format_i18n( $duration ) ) ); ?>
                    </span>
                </li>
				<?php if ( ! empty( $phone ) ): ?>
                    <li>
                        <span class="timefix-service-attribute-title"><?php esc_html_e( 'Phone', 'timefix' ); ?>:</span>
                        <span class="timefix-service-attribute-value"><?php echo esc_html( $phone ); ?></span>
                    </li>
				<?php endif; ?>
                <li>
                    <span class="timefix-service-attribute-title"><?php esc_html_e( 'WhatsApp', 'timefix' ); ?>:</span>
                    <span class="timefix-service-attribute-value"><?php echo esc_html( $whatsapp ); ?></span>
                </li>
                <li>
                    <span class="timefix-service-attribute-title"><?php esc_html_e( 'Email', 'timefix' ); ?>:</span>
                    <span class="timefix-service-attribute-value"><?php echo esc_html( $email ); ?></span>
                </li>
            </ul>
        </div>
		<?php
	}

	public static function available_staffs() {
		$staff_list = StaffHandler::get_staffs_by_service_id( get_the_ID() );

		if ( ! empty( $staff_list ) ) {
			?>
            <div class="timefix-section timefix-staff-section">
                <h3 class="timefix-section-heading"><?php esc_html_e( 'Our Specialist', 'timefix' ); ?></h3>
                <div class="timefix-grid timefix-columns-3 timefix-tab-columns-2 timefix-phone-columns-1">
					<?php
					foreach ( $staff_list as $staff_id ) {
						if ( wpm_timefix()->staff_post_type === get_post_type( $staff_id ) ) {
							$staff = get_post( $staff_id );
							if ( is_object( $staff ) ) {
								$designation = StaffMetaHandler::get_meta( $staff_id, 'speciality' );
								?>
                                <div class="timefix-staff-item">
									<?php if ( has_post_thumbnail() ) { ?>
                                        <div class="timefix-service-thumbnail">
                                            <div class="timefix-service-thumbnail-inner">
                                                <a href="<?php the_permalink( $staff->ID ); ?>"><?php echo get_the_post_thumbnail( $staff->ID, 'post-thumbnail' ); ?></a>
                                            </div>
                                        </div>
									<?php } ?>
                                    <div class="timefix-staff-item-content">
                                        <h4 class="timefix-staff-title">
                                            <a href="<?php the_permalink( $staff->ID ); ?>"><?php echo esc_html( $staff->post_title ); ?></a>
                                        </h4>
                                        <span class="timefix-staff-designation"><?php echo esc_html( $designation ); ?></span>
                                        <a href="<?php the_permalink( $staff->ID ); ?>"
                                           class="timefix-btn"><?php esc_html_e( 'Book Expert', 'timefix' ); ?></a>
                                    </div>
                                </div>
								<?php
							}
						}
					}
					?>
                </div>
            </div>
			<?php
		}
	}

	public static function main_container_start() {
		?>
        <div class="timefix timefix-container">
		<?php
	}

	public static function main_container_end() {
		?>
        </div>
		<?php
	}

	public static function service_item_wrapper_start() {
		?>
        <div class="timefix-service-item-wrapper timefix-grid timefix-columns-3 timefix-tab-columns-2 timefix-phone-columns-1">
		<?php
	}

public static function staff_item_wrapper_start() {
	?>
    <div class="timefix-staff-item-wrapper timefix-staff-archive timefix-grid timefix-columns-3 timefix-tab-columns-2 timefix-phone-columns-1">
	<?php
}

public static function staff_info_wrapper_start() {
	?>
    <div class="timefix-staff-info">
	<?php
}

public static function staff_info_wrapper_end() {
	?>
    </div>
	<?php
}

	public static function service_image() {
		if ( has_post_thumbnail() ) {
			?>
            <div class="timefix-service-thumbnail">
                <div class="timefix-service-thumbnail-inner">
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'post-thumbnail' ); ?></a>
                </div>
            </div>
			<?php
		}
	}

	public static function staff_image() {
		if ( has_post_thumbnail() ) {
			?>
            <div class="timefix-staff-thumbnail">
                <div class="timefix-staff-thumbnail-inner">
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'post-thumbnail' ); ?></a>
                </div>
            </div>
			<?php
		}
	}

	public static function service_title() {
		?>
        <h3 class="timefix-service-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		<?php
	}

	public static function staff_title() {
		?>
        <h3 class="timefix-staff-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		<?php
	}

	public static function service_excerpt() {
		?>
        <p class="timefix-service-excerpt"><?php echo wp_kses_post( get_the_excerpt() ); ?></p>
		<?php
	}

	public static function service_read_more_button() {
		?>
        <div class="timefix-service-button">
            <a class="timefix-btn" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'timefix' ); ?></a>
        </div>
		<?php
	}

public static function service_item_wrapper_end() {
	?>
    </div>
	<?php
}

	public static function staff_item_wrapper_end() {
		?>
        </div>
		<?php
	}

	public static function pagination() {
		Functions::pagination();
	}

}
