<?php

namespace WPMinimize\TimeFix\Frontend;

use WPMinimize\TimeFix\Helpers\Functions;
use WPMinimize\TimeFix\Helpers\GatewayManager;
use WPMinimize\TimeFix\Helpers\Options;

defined( 'ABSPATH' ) || exit;

class Shortcodes {
	public function __construct() {
		add_shortcode( 'timefix_appointment_form', [ $this, 'appointment_form_shortcode' ] );
	}

	public function appointment_form_shortcode( $atts ) {
		$atts = shortcode_atts( [
			'form_id' => '',
			'layout'  => '1',
		], $atts );

		$terms        = Functions::get_taxonomy_terms_hierarchy( wpm_timefix()->tax_category );
		$date_options = Options::get_datepicker_options();

		$wc_payment_enabled_class = GatewayManager::is_woocommerce_payment_enabled() ? ' timefix-enabled-wc-payment' : '';

		ob_start();
		?>
        <div class="timefix-appointment-form-wrapper timefix">
            <form method="post" class="<?php echo esc_attr( $wc_payment_enabled_class ); ?>"
                  id="timefix-appointment-form" name="timefix_appointment_form">
                <div class="timefix-form-step" data-step="1">
                    <input type="hidden" id="user-id" name="user_id"
                           value="<?php echo esc_attr( get_current_user_id() ); ?>"/>
					<?php
					Functions::get_template( 'appointment-form/categories', [ 'terms' => $terms ] );
					Functions::get_template( 'appointment-form/services' );
					Functions::get_template( 'appointment-form/staffs' );
					Functions::get_template( 'appointment-form/date-time', [ 'date_options' => $date_options ] );
					?>
                    <button class="timefix-next-btn timefix-btn"
                            disabled><?php esc_html_e( 'Next', 'timefix' ); ?></button>
                </div>
				<?php if ( ! GatewayManager::is_woocommerce_payment_enabled() ) { ?>
                    <div class="timefix-form-step timefix-step-d-none" data-step="2">
						<?php
						Functions::get_template( 'appointment-form/customer-info' );
						?>
                        <button class="timefix-prev-btn timefix-btn"><?php esc_html_e( 'Back', 'timefix' ); ?></button>
                        <button class="timefix-next-btn timefix-btn"><?php esc_html_e( 'Next', 'timefix' ); ?></button>
                    </div>
                    <div class="timefix-form-step timefix-step-d-none timefix-appointments-final-step"
                         data-step="3">
						<?php
						Functions::get_template( 'appointment-form/additional-note' );
						Functions::get_template( 'appointment-form/overview' );
						?>
                        <button class="timefix-btn timefix-prev-btn">
							<?php esc_html_e( 'Back', 'timefix' ); ?>
                        </button>
                        <button type="submit" id="timefix-submit-booking" class="timefix-btn">
							<?php esc_html_e( 'Confirm', 'timefix' ); ?>
                        </button>
                    </div>
				<?php } ?>
            </form>
        </div>
		<?php

		return ob_get_clean();
	}
}