<?php

namespace WPMinimize\TimeFix\Emails;

class AppointmentSubmissionUserEmail extends EmailBase {
	public function get_id() {
		return 'appointment_submission_user_email';
	}

	public function get_default_subject() {
		return __( 'Your appointment has been submitted', 'timefix' );
	}

	public function get_default_heading() {
		return __( 'Appointment Submitted', 'timefix' );
	}

	public function get_default_recipient( $data ) {
		return $data['admin_email'] ?? '';
	}

	public function get_template_data( $data ) {
		return [
			'appointment_id'   => $data['appointment_id'] ?? '',
			'appointment_date' => $data['appointment_date'] ?? '',
			'appointment_time' => $data['appointment_time'] ?? '',
			'customer_name'    => $data['customer_name'] ?? '',
			'service_name'     => $data['service_name'] ?? '',
		];
	}

	public function get_template_name() {
		return 'emails/appointment-submission-user-email';
	}
}