<?php

namespace WPMinimize\TimeFix\Emails;

use WPMinimize\TimeFix\Helpers\Functions;

class AppointmentCancellationUserEmail extends EmailBase {
	public function get_id() {
		return 'appointment_cancellation_user_email';
	}

	public function get_default_subject() {
		$service_name     = $this->placeholders['service_name'] ?? '';
		$appointment_date = $this->placeholders['appointment_date'] ?? '';

		return sprintf(
			__( 'Your Appointment has been Cancelled – %s on %s', 'timefix' ),
			$service_name,
			$appointment_date
		);
	}

	public function get_default_heading() {
		return __( 'Appointment Cancellation Notice', 'timefix' );
	}

	public function get_default_recipient( $data ) {
		return $data['customer_email'] ?? '';
	}

	public function get_template_name() {
		return 'emails/appointment-cancellation-user-email';
	}

	public function get_template_data( $data ) {
		$appointment_id   = $data['appointment_id'] ?? '';
		$appointment_info = [];
		if ( $appointment_id ) {
			$appointment = Functions::get_appointment_by_id( $appointment_id );

			if ( ! empty( $appointment ) ) {
				$appointment_info = [
					'appointment_id'   => $appointment->appointment_id,
					'service_name'     => get_the_title( $appointment->service_id ),
					'staff_name'       => get_the_title( $appointment->staff_id ),
					'customer_name'    => $appointment->name,
					'appointment_date' => $appointment->appointment_date,
					'appointment_time' => $appointment->start_time . '-' . $appointment->end_time,
				];
			}
		}

		return $appointment_info;
	}
}