<?php

namespace WPMinimize\TimeFix\Common;

defined( 'ABSPATH' ) || exit;

class StaffHandler {
	public static function get_all_staffs() {
		global $wpdb;

		$query   = $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts}  WHERE post_type = %s  AND post_status = 'publish' ORDER BY post_date DESC", wpm_timefix()->staff_post_type );
		$results = $wpdb->get_results( $query );
		$posts   = [];

		foreach ( $results as $row ) {
			$posts[ $row->ID ] = $row->post_title;
		}

		return $posts;
	}

	public static function get_staffs_by_service_id( $service_id = 0 ) {
		$staff_services = StaffMetaHandler::get_data_by_meta_key( 'service_assigned' );
		$staff_ids      = [];

		if ( ! empty( $staff_services ) ) {
			foreach ( $staff_services as $staff_id => $services ) {
				if ( in_array( $service_id, $services ) ) {
					$staff_ids[] = $staff_id;
				}
			}
		}

		return $staff_ids;
	}

}