<?php

namespace WPMinimize\TimeFix\Common;

defined( 'ABSPATH' ) || exit;

class ServiceMetaHandler {
	protected static string $meta_table = "wpm_timefix_service_meta";

	/**
	 * @param $service_post_id
	 * @param $meta_key
	 *
	 * @return array|string|null
	 */
	public static function get_meta( $service_post_id, $meta_key = '' ) {
		global $wpdb;

		$table_name = $wpdb->prefix . self::$meta_table;

		if ( empty( $meta_key ) ) {
			$data  = [];
			$query = $wpdb->get_results( $wpdb->prepare( "SELECT meta_key, meta_value FROM {$table_name} WHERE service_id = %d", [
				$service_post_id
			] ), ARRAY_A );

			if ( ! empty( $query ) ) {
				foreach ( $query as $metas ) {
					if ( isset( $metas['meta_key'] ) && isset( $metas['meta_value'] ) ) {
						$data[ $metas['meta_key'] ] = $metas['meta_value'];
					}
				}
			}

			return $data;
		} else {
			return $wpdb->get_var( $wpdb->prepare( "SELECT meta_value FROM {$table_name} WHERE service_id = %d AND meta_key = %s", [
				$service_post_id,
				$meta_key
			] ) );
		}
	}

	/**
	 * @param $service_post_id
	 * @param $meta_key
	 * @param $meta_value
	 *
	 * @return bool|int
	 */
	public static function update_meta( $service_post_id, $meta_key, $meta_value ) {
		global $wpdb;

		$table_name = $wpdb->prefix . self::$meta_table;

		$service_post_id = absint( $service_post_id );

		$meta_id = $wpdb->get_var( $wpdb->prepare( "SELECT meta_id FROM {$table_name} WHERE meta_key = %s AND service_id = %d", [
			$meta_key,
			$service_post_id
		] ) );

		if ( empty( $meta_id ) ) {
			return self::add_meta( $service_post_id, $meta_key, $meta_value );
		}

		$meta_value = maybe_serialize( $meta_value );

		$where = [
			'service_id' => $service_post_id,
			'meta_key'   => $meta_key,
		];

		$data = [
			'meta_value' => $meta_value
		];

		$result = $wpdb->update( $table_name, $data, $where );

		if ( ! $result ) {
			return false;
		}

		return true;
	}

	/**
	 * @param $service_post_id
	 * @param $meta_key
	 * @param $meta_value
	 *
	 * @return false|int
	 */
	public static function add_meta( $service_post_id, $meta_key, $meta_value ) {
		global $wpdb;

		$table_name = $wpdb->prefix . self::$meta_table;

		$service_post_id = absint( $service_post_id );

		$result = $wpdb->insert(
			$table_name,
			[
				'service_id' => $service_post_id,
				'meta_key'   => $meta_key,
				'meta_value' => maybe_serialize( $meta_value ),
			]
		);

		if ( ! $result ) {
			return false;
		}

		$mid = (int) $wpdb->insert_id;

		return $mid;
	}

	/**
	 * @param $service_post_id
	 * @param $meta_key
	 *
	 * @return bool
	 */
	public static function delete_meta( $service_post_id, $meta_key ) {
		global $wpdb;

		$table_name = $wpdb->prefix . self::$meta_table;

		$service_post_id = absint( $service_post_id );

		$query = $wpdb->prepare( "SELECT meta_id FROM {$table_name} WHERE meta_key = %s AND service_id = %d", [
			$meta_key,
			$service_post_id
		] );

		$meta_ids = $wpdb->get_col( $query );
		if ( ! count( $meta_ids ) ) {
			return false;
		}

		$meta_ids = array_map( 'absint', $meta_ids );

		$placeholders = implode( ',', array_fill( 0, count( $meta_ids ), '%d' ) );

		$query = $wpdb->prepare(
			"DELETE FROM {$table_name} WHERE meta_id IN ($placeholders)",
			$meta_ids
		);

		$count = $wpdb->query( $query );

		return (bool) $count;
	}
}