<?php

namespace WPMinimize\TimeFix\Common;

use WPMinimize\TimeFix\Helpers\Functions;

defined( 'ABSPATH' ) || exit;

class ServiceHandler {
	public static function get_all_services() {
		global $wpdb;

		$query   = $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts}  WHERE post_type = %s  AND post_status = 'publish' ORDER BY post_date DESC", wpm_timefix()->service_post_type );
		$results = $wpdb->get_results( $query );
		$posts   = [];

		foreach ( $results as $row ) {
			$posts[ $row->ID ] = $row->post_title;
		}

		return $posts;
	}

	public static function get_services_by_category_id( $category_id = 0 ) {

		$args = [
			'post_type'      => wpm_timefix()->service_post_type,
			'posts_per_page' => - 1
		];

		if ( ! empty( $category_id ) ) {
			$args['tax_query'] = [
				[
					'taxonomy' => wpm_timefix()->tax_category,
					'field'    => 'term_id',
					'terms'    => $category_id,
				]
			];
		}

		$query = new \WP_Query( $args );


		$services = [];

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$services[ get_the_ID() ] = get_the_title();
			}
		}

		wp_reset_postdata();

		return $services;
	}

	public static function get_services_by_staff_id( $staff_id = 0 ) {
		$service_assigned = StaffMetaHandler::get_meta( $staff_id, 'service_assigned' );
		$services_ids     = [];

		if ( is_array( $service_assigned ) ) {
			foreach ( $service_assigned as $service_id ) {
				if ( Functions::is_post_type_published( $service_id, wpm_timefix()->service_post_type ) ) {
					$services_ids[] = $service_id;
				}
			}
		}

		return $services_ids;
	}
}