<?php

namespace WPMinimize\TimeFix\Common;

defined( 'ABSPATH' ) || exit;

use WPMinimize\TimeFix\Helpers\Functions;

class PostTypes {

	public static function init() {
		add_action( 'init', [ __CLASS__, 'register_taxonomies' ], 5 );
		add_action( 'init', [ __CLASS__, 'register_post_types' ], 5 );
		add_action( 'init', [ __CLASS__, 'flush_rewrite_rules' ], 99 );
	}

	public static function flush_rewrite_rules() {
		if ( get_option( 'wpm_timefix_needs_flush' ) ) {
			flush_rewrite_rules();
			delete_option( 'wpm_timefix_needs_flush' );
		}
	}

	public static function register_taxonomies() {
		if ( ! is_blog_installed() ) {
			return;
		}

		if ( taxonomy_exists( wpm_timefix()->tax_category ) ) {
			return;
		}

		register_taxonomy(
			wpm_timefix()->tax_category,
			apply_filters( 'wpm_timefix_taxonomy_service_cat', [ wpm_timefix()->service_post_type ] ),
			apply_filters(
				'wpm_timefix_taxonomy_args_service_cat',
				array(
					'hierarchical' => true,
					'label'        => __( 'Categories', 'timefix' ),
					'labels'       => array(
						'name'                  => __( 'Categories', 'timefix' ),
						'singular_name'         => __( 'Category', 'timefix' ),
						'menu_name'             => _x( 'Service Categories', 'Admin menu name', 'timefix' ),
						'search_items'          => __( 'Search Categories', 'timefix' ),
						'all_items'             => __( 'All Categories', 'timefix' ),
						'parent_item'           => __( 'Parent Category', 'timefix' ),
						'parent_item_colon'     => __( 'Parent Category:', 'timefix' ),
						'edit_item'             => __( 'Edit Category', 'timefix' ),
						'update_item'           => __( 'Update Category', 'timefix' ),
						'add_new_item'          => __( 'Add New Category', 'timefix' ),
						'new_item_name'         => __( 'New Category Name', 'timefix' ),
						'not_found'             => __( 'No Categories Found', 'timefix' ),
						'item_link'             => __( 'Service Category Link', 'timefix' ),
						'item_link_description' => __( 'A link to a ervice category.', 'timefix' ),
						'template_name'         => _x( 'Services by Category', 'Template name', 'timefix' ),
					),
					'show_in_rest' => true,
					'show_ui'      => true,
					'query_var'    => true,
					'capabilities' => array(
						'manage_terms' => 'manage_categories',
						'edit_terms'   => 'manage_categories',
						'delete_terms' => 'manage_categories',
						'assign_terms' => 'edit_posts',
					),
					'rewrite'      => array(
						'slug'       => 'service-category',
						'with_front' => false,
					),
				)
			)
		);
	}

	public static function register_post_types() {
		if ( ! is_blog_installed() || post_type_exists( wpm_timefix()->service_post_type ) ) {
			return;
		}

		$has_service_archive = $has_staff_archive = false;

		$supports = [ 'title', 'editor', 'excerpt', 'thumbnail', 'custom-fields', 'comments' ];

		$permalinks = Functions::get_permalink_structure();

		if ( ! empty( $permalinks['service_archive_base'] ) ) {
			$has_service_archive = sanitize_text_field( $permalinks['service_archive_base'] );
		}

		if ( ! empty( $permalinks['staff_archive_base'] ) ) {
			$has_staff_archive = sanitize_text_field( $permalinks['staff_archive_base'] );
		}

		register_post_type(
			wpm_timefix()->service_post_type,
			apply_filters(
				'wpm_timefix_register_post_type_services',
				array(
					'labels'              => array(
						'name'                  => __( 'Services', 'timefix' ),
						'singular_name'         => __( 'Service', 'timefix' ),
						'all_items'             => __( 'All Services', 'timefix' ),
						'menu_name'             => _x( 'TimeFix', 'Admin menu name', 'timefix' ),
						'add_new'               => __( 'Add New', 'timefix' ),
						'add_new_item'          => __( 'Add New Service', 'timefix' ),
						'edit'                  => __( 'Edit', 'timefix' ),
						'edit_item'             => __( 'Edit Service', 'timefix' ),
						'new_item'              => __( 'New Service', 'timefix' ),
						'view_item'             => __( 'View service', 'timefix' ),
						'view_items'            => __( 'View services', 'timefix' ),
						'search_items'          => __( 'Search services', 'timefix' ),
						'not_found'             => __( 'No services found', 'timefix' ),
						'not_found_in_trash'    => __( 'No services found in trash', 'timefix' ),
						'parent'                => __( 'Parent service', 'timefix' ),
						'featured_image'        => __( 'Service image', 'timefix' ),
						'set_featured_image'    => __( 'Set service image', 'timefix' ),
						'remove_featured_image' => __( 'Remove service image', 'timefix' ),
						'use_featured_image'    => __( 'Use as service image', 'timefix' ),
						'insert_into_item'      => __( 'Add into service', 'timefix' ),
						'uploaded_to_this_item' => __( 'Uploaded to this service', 'timefix' ),
						'filter_items_list'     => __( 'Filter services', 'timefix' ),
						'items_list_navigation' => __( 'Services navigation', 'timefix' ),
						'items_list'            => __( 'Services list', 'timefix' ),
						'item_link'             => __( 'Service Link', 'timefix' ),
						'item_link_description' => __( 'A link to a service.', 'timefix' ),
					),
					'description'         => __( 'This is the place where you can browse services.', 'timefix' ),
					'public'              => true,
					'show_ui'             => true,
					'menu_icon'           => WPM_TIMEFIX_URL . '/assets/images/icon-24x24.png',
					'publicly_queryable'  => true,
					'exclude_from_search' => false,
					'hierarchical'        => false,
					'rewrite'             => $permalinks['service_single_base'] ? [
						'slug'       => $permalinks['service_single_base'],
						'with_front' => false
					] : false,
					'query_var'           => true,
					'supports'            => $supports,
					'has_archive'         => $has_service_archive,
					'show_in_nav_menus'   => true,
					'show_in_rest'        => true,
				)
			)
		);

		register_post_type(
			wpm_timefix()->staff_post_type,
			apply_filters(
				'wpm_timefix_register_post_type_staffs',
				array(
					'label'               => __( 'Staffs', 'timefix' ),
					'labels'              => [
						'name'               => __( 'Staffs', 'timefix' ),
						'singular_name'      => __( 'Staff', 'timefix' ),
						'menu_name'          => _x( 'Staffs', 'Admin menu name', 'timefix' ),
						'name_admin_bar'     => _x( 'Staffs', 'Admin menu name', 'timefix' ),
						'all_items'          => __( 'Staffs', 'timefix' ),
						'add_new'            => __( 'Add New', 'timefix' ),
						'add_new_item'       => __( 'Add New Staff', 'timefix' ),
						'new_item'           => __( 'New Staff', 'timefix' ),
						'edit_item'          => __( 'Edit Staff', 'timefix' ),
						'view_item'          => __( 'View Staff', 'timefix' ),
						'update_item'        => __( 'Update Staff', 'timefix' ),
						'search_items'       => __( 'Search Staffs', 'timefix' ),
						'not_found'          => __( 'No staffs found', 'timefix' ),
						'not_found_in_trash' => __( 'No staffs found in trash', 'timefix' ),
					],
					'description'         => __( 'This is the place where you can browse all Staffs.', 'timefix' ),
					'supports'            => [ 'title', 'editor', 'excerpt', 'thumbnail' ],
					'hierarchical'        => false,
					'public'              => true,
					'show_ui'             => true,
					'show_in_menu'        => 'edit.php?post_type=' . wpm_timefix()->service_post_type,
					'publicly_queryable'  => true,
					'exclude_from_search' => false,
					'rewrite'             => $permalinks['staff_single_base'] ? [
						'slug'       => $permalinks['staff_single_base'],
						'with_front' => false
					] : false,
					'query_var'           => true,
					'has_archive'         => $has_staff_archive,
					'show_in_nav_menus'   => true,
					'can_export'          => true,
					'show_in_rest'        => true,
				)
			)
		);
	}

}