<?php

namespace WPMinimize\TimeFix\Common;

use WPMinimize\TimeFix\Helpers\EmailManager;
use WPMinimize\TimeFix\Helpers\Functions;

defined( 'ABSPATH' ) || exit;

class EmailHooks {

	public static function init() {
		add_action( 'wpm_timefix_email_header', [ __CLASS__, 'email_header' ] );
		add_action( 'wpm_timefix_email_footer', [ __CLASS__, 'email_footer' ] );
		add_action( 'wpm_timefix_appointment_submission_success', [
			__CLASS__,
			'appointment_submission_email'
		], 10, 2 );
		add_action( 'wpm_timefix_appointment_updated', [ __CLASS__, 'appointment_update_email' ], 10, 3 );
	}

	public static function email_header( $heading ) {
		Functions::get_template( 'emails/email-header', [ 'heading' => $heading ] );
	}

	public static function email_footer() {
		Functions::get_template( 'emails/email-footer' );
	}

	public static function appointment_submission_email( $appointment_id, $appointment_data = [] ) {
		if ( $appointment_id ) {
			$email_settings = Functions::get_option( 'wpm_timefix_email_settings' );
			$notify_admin   = $email_settings['notify_admin'] ?? [];
			$notify_user    = $email_settings['notify_user'] ?? [];
			$customer_email = $appointment_data['customer_email'] ?? '';

			if ( $notify_user || $notify_admin ) {
				$email_manager = new EmailManager();
				$admin_email   = ! empty( $email_settings['admin_email'] ) ? sanitize_email( $email_settings['admin_email'] ) : '';

				$appointment_data['appointment_id'] = $appointment_id;

				// Send appointment submission admin email
				if ( $admin_email && in_array( 'appointment_submission', $notify_admin ) ) {
					$email_manager->send_email( 'appointment_submission_admin', $admin_email, $appointment_data );
				}
				// Send appointment submission user email
				if ( $customer_email && in_array( 'appointment_submission', $notify_user ) ) {
					$email_manager->send_email( 'appointment_submission_user', $customer_email, $appointment_data );
				}
			}
		}
	}

	public static function appointment_update_email( $appointment_id, $status, $appointment_data = [] ) {
		if ( $appointment_id ) {
			$email_settings = Functions::get_option( 'wpm_timefix_email_settings' );
			$notify_user    = $email_settings['notify_user'] ?? [];
			$customer_email = $appointment_data['customer_email'] ?? '';

			if ( $notify_user && $customer_email ) {
				$email_manager = new EmailManager();
				// Send appointment confirmation customer email
				if ( 'confirmed' === $status && in_array( 'appointment_confirmation', $notify_user ) ) {
					$email_manager->send_email( 'appointment_confirmation_user', $customer_email, $appointment_data );
				}
				// Send appointment cancellation customer email
				if ( 'cancelled' === $status && in_array( 'appointment_cancellation', $notify_user ) ) {
					$email_manager->send_email( 'appointment_cancellation_user', $customer_email, $appointment_data );
				}
			}
		}
	}
}
