<?php

namespace WPMinimize\TimeFix\Api;

defined( 'ABSPATH' ) || exit;

use WPMinimize\TimeFix\Api\V1\AppointmentsApi;
use WPMinimize\TimeFix\Api\V1\CustomersApi;
use WPMinimize\TimeFix\Api\V1\PaymentsApi;
use WPMinimize\TimeFix\Api\V1\SettingsApi;

class ApiInit {

	public function run() {
		add_action( 'rest_api_init', [ $this, 'init_rest_routes' ], 99 );
	}

	public function init_rest_routes() {
		$settings     = new SettingsApi();
		$appointments = new AppointmentsApi();
		$payments     = new PaymentsApi();
		$customers    = new CustomersApi();

		$settings->register_routes();
		$appointments->register_routes();
		$payments->register_routes();
		$customers->register_routes();
	}

}