<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

use WP_Post;
use WPMinimize\TimeFix\Common\StaffMetaHandler;
use WPMinimize\TimeFix\Helpers\Functions;

class StaffFields {

	public static function information_fields( $post_id = 0 ) {
		$services = StaffMetaHandler::get_meta( $post_id, 'service_assigned' );

		$data = [
			'post_id'    => $post_id,
			'speciality' => StaffMetaHandler::get_meta( $post_id, 'speciality' ),
			'experience' => StaffMetaHandler::get_meta( $post_id, 'experience' ),
			'email'      => StaffMetaHandler::get_meta( $post_id, 'email' ),
			'phone'      => StaffMetaHandler::get_meta( $post_id, 'phone' ),
			'services'   => ! empty( $services ) && is_array( $services ) ? $services : []
		];

		Functions::get_template( 'staff-form/information', apply_filters( 'wpm_timefix_staff_form_information_data', $data, $post_id ) );
	}

	public static function schedule_fields( $post_id = 0 ) {
		$data = [
			'post_id'               => $post_id,
			'weekly_schedule'       => StaffMetaHandler::get_meta( $post_id, 'weekly_schedule' ),
			'holidays'              => StaffMetaHandler::get_meta( $post_id, 'holidays' ),
			'special_date_schedule' => StaffMetaHandler::get_meta( $post_id, 'special_schedule' ),
		];

		Functions::get_template( 'staff-form/schedule', apply_filters( 'wpm_timefix_staff_form_schedule_data', $data, $post_id ) );
	}

	public static function social_profiles( $post_id = 0 ) {
		$social = StaffMetaHandler::get_meta( $post_id, 'social_profiles' );
		$data   = [
			'post_id'         => $post_id,
			'social_profiles' => ! empty( $social ) && is_array( $social ) ? $social : [],
		];

		Functions::get_template( 'staff-form/social-profiles', apply_filters( 'wpm_timefix_staff_form_social_profiles', $data, $post_id ) );
	}

	public static function note_fields( $post_id = 0 ) {
		$data = [
			'post_id' => $post_id,
			'note'    => StaffMetaHandler::get_meta( $post_id, 'note' ),
		];

		Functions::get_template( 'staff-form/note', apply_filters( 'wpm_timefix_staff_form_note_data', $data, $post_id ) );
	}

	public static function staff_fields( WP_Post $post ) {
		$post_id = $post->ID;

		wp_nonce_field( wpm_timefix()->nonceText, wpm_timefix()->nonceId );

		self::information_fields( $post_id );
		self::schedule_fields( $post_id );
		self::social_profiles( $post_id );
		self::note_fields( $post_id );
	}
}