<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

use WP_Post;
use WPMinimize\TimeFix\Common\ServiceMetaHandler;
use WPMinimize\TimeFix\Helpers\Functions;

class ServiceFields {
	public static function general_fields( $post_id = 0 ) {

		$data = [
			'post_id'       => $post_id,
			'duration'      => ServiceMetaHandler::get_meta( $post_id, 'duration' ),
			'time_interval' => ServiceMetaHandler::get_meta( $post_id, 'time_interval' ),
		];

		Functions::get_template( 'service-form/general', apply_filters( 'wpm_timefix_service_form_general_data', $data, $post_id ) );
	}

	public static function staff_list( $post_id = 0 ) {

		$data = [
			'post_id' => $post_id,
			'staffs'  => '',
		];

		Functions::get_template( 'service-form/staff-list', apply_filters( 'wpm_timefix_service_form_staff_list', $data, $post_id ) );
	}

	public static function contact_fields( $post_id = 0 ) {

		$data = [
			'post_id'  => $post_id,
			'phone'    => ServiceMetaHandler::get_meta( $post_id, 'phone' ),
			'whatsapp' => ServiceMetaHandler::get_meta( $post_id, 'whatsapp' ),
			'email'    => ServiceMetaHandler::get_meta( $post_id, 'email' ),
		];

		Functions::get_template( 'service-form/contact', apply_filters( 'wpm_timefix_service_form_contact_data', $data, $post_id ) );
	}

	public static function pricing_fields( $post_id = 0 ) {

		$data = [
			'post_id'    => $post_id,
			'price_type' => ServiceMetaHandler::get_meta( $post_id, 'price_type' ),
			'price'      => ServiceMetaHandler::get_meta( $post_id, 'price' )
		];

		Functions::get_template( 'service-form/pricing', apply_filters( 'wpm_timefix_service_form_price_data', $data, $post_id ) );
	}

	public static function service_fields( WP_Post $post ) {
		$post_id = $post->ID;

		wp_nonce_field( wpm_timefix()->nonceText, wpm_timefix()->nonceId );

		self::general_fields( $post_id );
		self::pricing_fields( $post_id );
		//self::staff_list( $post_id );
		self::contact_fields( $post_id );
	}

}