<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

use WPMinimize\TimeFix\Common\ServiceMetaHandler;
use WPMinimize\TimeFix\Common\StaffMetaHandler;
use WPMinimize\TimeFix\Helpers\Functions;

class SavePostMeta {
	public static function init() {
		add_action( 'save_post', [ __CLASS__, 'save_service_meta_data' ], 10, 2 );
		add_action( 'save_post', [ __CLASS__, 'save_staff_meta_data' ], 10, 2 );
	}

	public static function save_service_meta_data( $post_id, $post ) {
		if ( ! wp_verify_nonce( isset( $_REQUEST[ wpm_timefix()->nonceId ] ) ? sanitize_text_field( $_REQUEST[ wpm_timefix()->nonceId ] ) : null, wpm_timefix()->nonceText ) ) {
			return $post_id;
		}

		if ( ! isset( $_POST['post_type'] ) ) {
			return $post_id;
		}

		if ( wpm_timefix()->service_post_type != $post->post_type ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			return $post_id;
		}

		$duration      = isset( $_POST['timefix_duration'] ) ? absint( $_POST['timefix_duration'] ) : 0;
		$duration_unit = isset( $_POST['timefix_duration_unit'] ) ? sanitize_text_field( $_POST['timefix_duration_unit'] ) : 'minute';

		$duration_in_minutes = $duration;
		if ( $duration_unit === 'hour' ) {
			$duration_in_minutes = $duration * 60;
		}

		ServiceMetaHandler::update_meta( $post_id, 'duration', $duration_in_minutes );

		if ( isset( $_POST['timefix_time_interval'] ) ) {
			ServiceMetaHandler::update_meta( $post_id, 'time_interval', sanitize_text_field( $_POST['timefix_time_interval'] ) );
		}

		if ( ! empty( $_POST['timefix_price_type'] ) ) {
			ServiceMetaHandler::update_meta( $post_id, 'price_type', sanitize_text_field( $_POST['timefix_price_type'] ) );
		}

		if ( isset( $_POST['timefix_price'] ) ) {
			ServiceMetaHandler::update_meta( $post_id, 'price', absint( $_POST['timefix_price'] ) );
		}

		if ( isset( $_POST['timefix_phone'] ) ) {
			ServiceMetaHandler::update_meta( $post_id, 'phone', sanitize_text_field( $_POST['timefix_phone'] ) );
		}

		if ( isset( $_POST['timefix_whatsapp'] ) ) {
			ServiceMetaHandler::update_meta( $post_id, 'whatsapp', sanitize_text_field( $_POST['timefix_whatsapp'] ) );
		}

		if ( isset( $_POST['timefix_email'] ) ) {
			ServiceMetaHandler::update_meta( $post_id, 'email', sanitize_email( $_POST['timefix_email'] ) );
		}
	}

	public static function save_staff_meta_data( $post_id, $post ) {
		if ( ! wp_verify_nonce( isset( $_REQUEST[ wpm_timefix()->nonceId ] ) ? sanitize_text_field( $_REQUEST[ wpm_timefix()->nonceId ] ) : null, wpm_timefix()->nonceText ) ) {
			return $post_id;
		}

		if ( ! isset( $_POST['post_type'] ) ) {
			return $post_id;
		}

		if ( wpm_timefix()->staff_post_type != $post->post_type ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			return $post_id;
		}

		if ( ! empty( $_POST['timefix_staff_note'] ) ) {
			StaffMetaHandler::update_meta( $post_id, 'note', sanitize_textarea_field( $_POST['timefix_staff_note'] ) );
		}

		if ( ! empty( $_POST['timefix_speciality'] ) ) {
			StaffMetaHandler::update_meta( $post_id, 'speciality', sanitize_text_field( $_POST['timefix_speciality'] ) );
		}

		if ( ! empty( $_POST['timefix_experience'] ) ) {
			StaffMetaHandler::update_meta( $post_id, 'experience', sanitize_text_field( $_POST['timefix_experience'] ) );
		}

		if ( ! empty( $_POST['timefix_email'] ) ) {
			StaffMetaHandler::update_meta( $post_id, 'email', sanitize_email( $_POST['timefix_email'] ) );
		}

		if ( ! empty( $_POST['timefix_phone'] ) ) {
			StaffMetaHandler::update_meta( $post_id, 'phone', sanitize_text_field( $_POST['timefix_phone'] ) );
		}

		if ( ! empty( $_POST['timefix_services'] ) && is_array( $_POST['timefix_services'] ) ) {
			$services = array_unique( array_map( 'absint', $_POST['timefix_services'] ) );

			if ( ! empty( $services ) ) {
				StaffMetaHandler::update_meta( $post_id, 'service_assigned', $services );
			}
		}

		if ( ! empty( $_POST['social_profiles'] ) && is_array( $_POST['social_profiles'] ) ) {
			$social_profile = [];
			foreach ( $_POST['social_profiles'] as $key => $profile ) {
				if ( ! empty( $profile ) ) {
					$social_profile[ $key ] = sanitize_url( $profile );
				}
			}
			if ( ! empty( $social_profile ) ) {
				StaffMetaHandler::update_meta( $post_id, 'social_profiles', $social_profile );
			}
		}

		if ( isset( $_POST['_timefix_staff_schedule'] ) && is_array( $_POST['_timefix_staff_schedule'] ) ) {
			$weekly_schedule = Functions::sanitize( $_POST['_timefix_staff_schedule'], 'weekly_schedule' );
			if ( ! empty( $weekly_schedule ) ) {
				StaffMetaHandler::update_meta( $post_id, 'weekly_schedule', $weekly_schedule );
			}
		}

		if ( isset( $_POST['_timefix_staff_special_schedule'] ) && is_array( $_POST['_timefix_staff_special_schedule'] ) ) {
			$special_schedule = Functions::sanitize( $_POST['_timefix_staff_special_schedule'], 'special_schedule' );

			if ( ! empty( $special_schedule ) ) {
				StaffMetaHandler::update_meta( $post_id, 'special_schedule', $special_schedule );
			}
		}

		if ( isset( $_POST['_timefix_staff_holidays'] ) && ! empty( $_POST['_timefix_staff_holidays'][0] ) ) {
			$holidays = [];
			foreach ( $_POST['_timefix_staff_holidays'] as $date ) {
				if ( ! empty( $date ) ) {
					$holidays[] = Functions::sanitize( $date, 'date' );
				}
			}
			if ( ! empty( $holidays ) ) {
				StaffMetaHandler::update_meta( $post_id, 'holidays', $holidays );
			}
		}

	}
}