<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

class RegisterMetaFields {
	public static function init() {
		add_action( 'add_meta_boxes', [ __CLASS__, 'service_meta_fields' ] );
		add_action( 'add_meta_boxes', [ __CLASS__, 'staff_meta_fields' ], 8 );
		add_action( 'timefix_categories_add_form_fields', [ __CLASS__, 'add_category_meta_field' ] );
		add_action( 'timefix_categories_edit_form_fields', [ __CLASS__, 'edit_category_meta_field' ] );
	}

	public static function add_category_meta_field() {
		?>
        <div class="form-field timefix-term-group-wrap">
            <label for="tag-timefix-order"><?php esc_html_e( 'Order', 'timefix' ); ?></label>
            <input type="number" name="_timefix_order" id="tag-timefix-order" value="">
            <p class="description"><?php esc_html_e( 'Enter an integer value for this order', 'timefix' ); ?></p>
        </div>
        <div class="form-field timefix-term-group-wrap">
            <label for="timefix-category-image-id"><?php esc_html_e( 'Image', 'timefix' ); ?></label>
            <input type="hidden" class="timefix-category-image-id" id="timefix-category-image-id"
                   name="_timefix_image"/>
            <div class="timefix-category-image-wrapper"></div>
            <p>
                <input type="button" class="timefix-category-upload-image timefix-btn"
                       id="timefix-category-upload-image"
                       value="<?php esc_html_e( 'Add Image', 'timefix' ); ?>"/>
                <input type="button" class="timefix-category-remove-image timefix-btn"
                       id="timefix-category-remove-image"
                       value="<?php esc_html_e( 'Remove Image', 'timefix' ); ?>"/>
            </p>
        </div>
		<?php
	}

	public static function edit_category_meta_field( $term ) {
		$term_id   = $term->term_id;
		$image_id  = absint( get_term_meta( $term_id, "_timefix_image", true ) );
		$image_src = $image_id ? wp_get_attachment_thumb_url( $image_id ) : '';
		$order     = absint( get_term_meta( $term_id, "_timefix_order", true ) );
		?>
        <tr class="form-field timefix-term-group-wrap">
            <th scope="row">
                <label for="tag-timefix-order"><?php esc_html_e( 'Order', 'timefix' ); ?></label>
            </th>
            <td>
                <input type="number" name="_timefix_order" id="tag-timefix-order"
                       value="<?php echo $order ? esc_attr( $order ) : 0; ?>">
                <p class="description"><?php esc_html_e( 'Enter an integer value for this order', 'timefix' ); ?></p>
            </td>
        </tr>
        <tr class="form-field timefix-term-group-wrap">
            <th scope="row">
                <label for="timefix-category-image-id"><?php esc_html_e( 'Image', 'timefix' ); ?></label>
            </th>
            <td>
                <input type="hidden" class="timefix-categpru-image-id" id="timefix-category-image-id"
                       name="_timefix_image"
                       value="<?php echo esc_attr( $image_id ); ?>"/>
                <div class="timefix-category-image-wrapper">
					<?php if ( $image_src ) : ?>
                        <img src="<?php echo esc_url( $image_src ); ?>" alt="image"/>
					<?php endif; ?>
                </div>
                <p>
                    <input type="button" class="timefix-category-upload-image timefix-btn"
                           id="timefix-category-upload-image"
                           value="<?php esc_html_e( 'Add Image', 'timefix' ); ?>"/>
                    <input type="button" class="timefix-category-remove-image timefix-btn"
                           id="timefix-category-remove-image"
                           value="<?php esc_html_e( 'Remove Image', 'timefix' ); ?>"/>
                </p>
            </td>
        </tr>
		<?php
	}

	public static function service_meta_fields() {
		add_meta_box(
			'wpm_timefix_service_settings',
			__( 'Service Details', 'timefix' ),
			[ ServiceFields::class, 'service_fields' ],
			wpm_timefix()->service_post_type,
			'normal',
			'high'
		);
	}

	public static function staff_meta_fields() {
		add_meta_box(
			'wpm_timefix_staff_settings',
			__( 'Staff Details', 'timefix' ),
			[ StaffFields::class, 'staff_fields' ],
			wpm_timefix()->staff_post_type,
			'normal',
			'high'
		);
	}
}